#pragma once

#include "CoreMinimal.h"
#include "GamebaseError.h"
#include "GamebaseValueObject.h"

using FGamebaseLaunchingUpdateInfoPtr = TSharedPtr<struct FGamebaseLaunchingUpdateInfo, ESPMode::ThreadSafe>;

struct GAMEBASE_API FGamebaseLaunchingUpdateInfo final : FGamebaseValueObject
{
    FString InstallUrl;
    FString Message;
    FString DetailUrl;

    static FGamebaseLaunchingUpdateInfoPtr From(const FGamebaseError* Error);

    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};


struct GAMEBASE_API FGamebaseLaunchingInfo final : FGamebaseValueObject
{
    struct FLaunching final
    {
        struct FStatus final
        {
            int32 Code;
            FString Message;
        };
        
        struct FApp final
        {
            struct FAccessInfo final
            {
                FString ServerAddress;
            };
            
            struct FRelatedUrls final
            {
                FString TermsUrl;
                FString PunishRuleUrl;
                FString PersonalInfoCollectionUrl;
            };
            
            struct FInstall final
            {
                FString Url;
                FString DetailUrl;
            };
            
            struct FIdp final
            {
                struct FLoginWebView final
                {
                    FString TitleBgColor;
                    FString TitleTextColor;
                    FString Title;
                };

                struct FChannels final
                {
                    FString Region;
                    FString ClientId;
                    FString ClientSecret;
                };
                
                TOptional<FString> ClientId;
                TOptional<FString> ClientSecret;
                TOptional<FString> Additional;
                TOptional<FString> CallbackUrl;
                TOptional<FLoginWebView> LoginWebView;
                TArray<FChannels> Channels;
            };
            
            struct FLoginUrls final
            {
                FString GamebaseUrl;
            };
            
            struct FLanguage final
            {
                FString DeviceLanguage;
                FString DefaultLanguage;
            };
            
            struct FCustomerService final
            {
                FString Type;
                FString Url;
                FString AccessInfo;
            };

            struct FTermsService final
            {
                bool bShowTermsFlag;
                FString TermsUrl;
            };

            struct FGameNotice final
            {
                FString Url;
            };
        
            FAccessInfo AccessInfo;
            TMap<FString, FIdp> Idp;
            FInstall Install;
            FRelatedUrls RelatedUrls;
            FLanguage Language;
            FString StoreCode;
            FString TypeCode;
            FLoginUrls LoginUrls;
            TOptional<FCustomerService> CustomerService;
            TOptional<FGameNotice> GameNotice;
            TOptional<FTermsService> TermsService;
        };
        
        struct FMaintenance final
        {
            FString Url;
            FString TypeCode;
            FString PageTypeCode;
            FString Reason;
            FString Message;
            FString Timezone;
            FString BeginDate;
            FString EndDate;
            int64 LocalBeginDate;
            int64 LocalEndDate;
            bool bHideDate;
        };

        struct FNotice final
        {
            FString Message;
            FString Title;
            FString Url;
        };

        struct FUser final
        {
            struct FTestDevice
            {
                bool bMatchingFlag;
                TArray<FString> MatchingTypes;
            };

            TOptional<FTestDevice> TestDevice;
        };
        
        struct FTcgbClient final
        {
            struct FStability final
            {
                bool bUseFlag;
                bool bUseFlagSpecificUser;
                FString LogLevel;
                FString AppKey;
                int64 AppKeyVersion;
                int32 InitFailCount;
                TArray<FString> SecurityBlacklist;
            };

            struct FForceRemoteSettings final
            {
                struct FLog final
                {
                    FString Policy;
                    FString Indicator;
                    FString Reason;
                    FString AppKeyIndicator;
                    FString AppKeyLog;
                };

                FLog Log;
            };
                
            struct FIntrospection final
            {
                int32 IntervalSeconds;
            };  
            
            FStability Stability;
            TOptional<FForceRemoteSettings> ForceRemoteSettings;
            TOptional<FIntrospection> Introspection;
        };
        
        FStatus Status;
        FApp App;
        TOptional<FMaintenance> Maintenance;
        TOptional<FNotice> Notice;
        TOptional<FTcgbClient> TcgbClient;
        TOptional<FUser> User;
    };
    
    struct FTcProductInfo final
    {
        struct FAppKeyInfo
        {
            FString AppKey;
        };

        struct FIapInfo final : FAppKeyInfo
        {
            FString Url;
        };

        FAppKeyInfo Gamebase;
        FAppKeyInfo TcLaunching;
        FIapInfo Iap;
        FAppKeyInfo Push;
    };
    
    struct FTcIapInfo final
    {
        FString Id;
        FString Name;
        FString StoreCode;
        FString StoreAppId;
    };
    
    FLaunching Launching;
    FTcProductInfo TcProduct;
    TArray<FTcIapInfo> TcIap;
    TOptional<FString> TcLaunching;
    
    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};

using FGamebaseLaunchingInfoPtr = TSharedPtr<FGamebaseLaunchingInfo, ESPMode::ThreadSafe>;
using FGamebaseLaunchingInfoRef = TSharedRef<FGamebaseLaunchingInfo, ESPMode::ThreadSafe>;

DECLARE_DELEGATE_TwoParams(FGamebaseLaunchingInfoDelegate, const FGamebaseLaunchingInfo* /*launchingInfo*/, const FGamebaseError* /*error*/);