#pragma once

#include "CoreMinimal.h"

namespace GamebaseLaunchingStatus
{
    /// <summary>
    /// Service is now normally provided.
    /// </summary>
    constexpr int32 IN_SERVICE = 200;
    /// <summary>
    /// Update is recommended.
    /// </summary>
    constexpr int32 RECOMMEND_UPDATE = 201;
    /// <summary>
    /// Under maintenance now but QA user service is available.
    /// </summary>
    constexpr int32 IN_SERVICE_BY_QA_WHITE_LIST = 202;
    /// <summary>
    /// Test.
    /// </summary>
    constexpr int32 IN_TEST = 203;
    /// <summary>
    /// Review.
    /// </summary>
    constexpr int32 IN_REVIEW = 204;
    /// <summary>
    /// Beta.
    /// </summary>
    constexpr int32 IN_BETA = 205;
    /// <summary>
    /// Update is required.
    /// </summary>
    constexpr int32 REQUIRE_UPDATE = 300;
    /// <summary>
    /// User whose access has been blocked.
    /// </summary>
    constexpr int32 BLOCKED_USER = 301;
    /// <summary>
    /// Service has been terminated.
    /// </summary>
    constexpr int32 TERMINATED_SERVICE = 302;
    /// <summary>
    /// Under maintenance now.
    /// </summary>
    constexpr int32 INSPECTING_SERVICE = 303;
    /// <summary>
    /// Under maintenance for the whole service.
    /// </summary>
    constexpr int32 INSPECTING_ALL_SERVICES = 304;
    /// <summary>
    /// Error of internal server.
    /// </summary>
    constexpr int32 INTERNAL_SERVER_ERROR = 500;
}