#pragma once

#include "CoreMinimal.h"

namespace GamebaseErrorCode
{
    //----------------------------------------
    //  Success
    //----------------------------------------
    constexpr int32 SUCCESS = 0;

    //----------------------------------------
    //  Common
    //----------------------------------------
    constexpr int32 NOT_INITIALIZED = 1;
    constexpr int32 NOT_LOGGED_IN = 2;
    constexpr int32 INVALID_PARAMETER = 3;
    constexpr int32 INVALID_JSON_FORMAT = 4;
    constexpr int32 USER_PERMISSION = 5;
    constexpr int32 INVALID_MEMBER = 6;
    constexpr int32 BANNED_MEMBER = 7;
    constexpr int32 SAME_REQUESTOR = 8;
    constexpr int32 NOT_GUEST_OR_HAS_OTHERS = 9;
    constexpr int32 NOT_SUPPORTED = 10;

    constexpr int32 NOT_SUPPORTED_ANDROID = 11; // <UNREAL ONLY>
    constexpr int32 NOT_SUPPORTED_IOS = 12; // <UNREAL ONLY>
    constexpr int32 NOT_SUPPORTED_UE4_EDITOR = 13; // <UNREAL ONLY>
    constexpr int32 NOT_SUPPORTED_UE4_STANDALONE = 14; // <UNREAL ONLY>

    constexpr int32 ANDROID_ACTIVITY_DESTROYED = 31; // <ANDROID ONLY>
    constexpr int32 ANDROID_ACTIVEAPP_NOT_CALLED = 32; // <ANDROID ONLY>

    constexpr int32 IOS_GAMECENTER_DENIED = 51; // <IOS ONLY>

    //----------------------------------------
    //  Network (Socket)
    //----------------------------------------
    constexpr int32 SOCKET_RESPONSE_TIMEOUT = 101;
    constexpr int32 SOCKET_ERROR = 110;

    constexpr int32 SOCKET_UNKNOWN_ERROR = 999;

    //----------------------------------------
    //  Launching
    //----------------------------------------
    constexpr int32 LAUNCHING_SERVER_ERROR = 2001;
    constexpr int32 LAUNCHING_NOT_EXIST_CLIENT_ID = 2002;
    constexpr int32 LAUNCHING_UNREGISTERED_APP = 2003;
    constexpr int32 LAUNCHING_UNREGISTERED_CLIENT = 2004;

    //----------------------------------------
    //  Auth
    //----------------------------------------
    constexpr int32 AUTH_USER_CANCELED = 3001;
    constexpr int32 AUTH_NOT_SUPPORTED_PROVIDER = 3002;
    constexpr int32 AUTH_NOT_EXIST_MEMBER = 3003;
    constexpr int32 AUTH_EXTERNAL_LIBRARY_INITIALIZATION_ERROR = 3006;
    constexpr int32 AUTH_EXTERNAL_LIBRARY_ERROR = 3009;
    constexpr int32 AUTH_ALREADY_IN_PROGRESS_ERROR = 3010;
    constexpr int32 AUTH_INVALID_GAMEBASE_TOKEN = 3011;
    constexpr int32 AUTH_AUTHENTICATION_SERVER_ERROR = 3012;
    constexpr int32 AUTH_LOGIN_CANCEL_FAILED = 3013;
    
    // transferAccount
    constexpr int32 AUTH_TRANSFERACCOUNT_EXPIRED = 3041;
    constexpr int32 AUTH_TRANSFERACCOUNT_BLOCK = 3042;
    constexpr int32 AUTH_TRANSFERACCOUNT_INVALID_ID = 3043;
    constexpr int32 AUTH_TRANSFERACCOUNT_INVALID_PASSWORD = 3044;
    constexpr int32 AUTH_TRANSFERACCOUNT_CONSOLE_NO_CONDITION = 3045;
    constexpr int32 AUTH_TRANSFERACCOUNT_NOT_EXIST = 3046;
    constexpr int32 AUTH_TRANSFERACCOUNT_ALREADY_EXIST_ID = 3047;
    constexpr int32 AUTH_TRANSFERACCOUNT_ALREADY_USED = 3048;

    // tokenLogin
    constexpr int32 AUTH_TOKEN_LOGIN_FAILED = 3101;
    constexpr int32 AUTH_TOKEN_LOGIN_INVALID_TOKEN_INFO = 3102;
    constexpr int32 AUTH_TOKEN_LOGIN_INVALID_LAST_LOGGED_IN_IDP = 3103;
    
    // idPLogin
    constexpr int32 AUTH_IDP_LOGIN_FAILED = 3201;
    constexpr int32 AUTH_IDP_LOGIN_INVALID_IDP_INFO = 3202;
    constexpr int32 AUTH_IDP_LOGIN_EXTERNAL_AUTHENTICATION_REQUIRED = 3203;
    
    // addMapping
    constexpr int32 AUTH_ADD_MAPPING_FAILED = 3301;
    constexpr int32 AUTH_ADD_MAPPING_ALREADY_MAPPED_TO_OTHER_MEMBER = 3302;
    constexpr int32 AUTH_ADD_MAPPING_ALREADY_HAS_SAME_IDP = 3303;
    constexpr int32 AUTH_ADD_MAPPING_INVALID_IDP_INFO = 3304;
    constexpr int32 AUTH_ADD_MAPPING_CANNOT_ADD_GUEST_IDP = 3305;

    constexpr int32 AUTH_ADD_MAPPING_FORCIBLY_NOT_EXIST_KEY = 3311;
    constexpr int32 AUTH_ADD_MAPPING_FORCIBLY_ALREADY_USED_KEY = 3312;
    constexpr int32 AUTH_ADD_MAPPING_FORCIBLY_EXPIRED_KEY = 3313;
    constexpr int32 AUTH_ADD_MAPPING_FORCIBLY_DIFFERENT_IDP = 3314;
    constexpr int32 AUTH_ADD_MAPPING_FORCIBLY_DIFFERENT_AUTHKEY = 3315;

    // removeMapping
    constexpr int32 AUTH_REMOVE_MAPPING_FAILED = 3401;
    constexpr int32 AUTH_REMOVE_MAPPING_LAST_MAPPED_IDP = 3402;
    constexpr int32 AUTH_REMOVE_MAPPING_LOGGED_IN_IDP = 3403;
    
    // logout
    constexpr int32 AUTH_LOGOUT_FAILED = 3501;
    
    // withdraw
    constexpr int32 AUTH_WITHDRAW_FAILED = 3601;
    constexpr int32 AUTH_WITHDRAW_ALREADY_TEMPORARY_WITHDRAW = 3602;
    constexpr int32 AUTH_WITHDRAW_NOT_TEMPORARY_WITHDRAW = 3603;
    
    // status not playable
    constexpr int32 AUTH_NOT_PLAYABLE = 3701;

    // bindToken
    constexpr int32 AUTH_BIND_TOKEN_FAILED = 3801;
    
    // unknown
    constexpr int32 AUTH_UNKNOWN_ERROR = 3999;

    //----------------------------------------
    //  Purchase
    //----------------------------------------
    constexpr int32 PURCHASE_NOT_INITIALIZED = 4001;
    constexpr int32 PURCHASE_USER_CANCELED = 4002;
    constexpr int32 PURCHASE_NOT_FINISHED_PREVIOUS_PURCHASING = 4003;
    constexpr int32 PURCHASE_NOT_ENOUGH_CASH = 4004;
    constexpr int32 PURCHASE_INACTIVE_PRODUCT_ID = 4005; // <NATIVE ONLY>
    constexpr int32 PURCHASE_NOT_EXIST_PRODUCT_ID = 4006; // <NATIVE ONLY>
    constexpr int32 PURCHASE_LIMIT_EXCEEDED = 4007;

    constexpr int32 PURCHASE_NOT_SUPPORTED_MARKET = 4010;

    constexpr int32 PURCHASE_EXTERNAL_LIBRARY_ERROR = 4201;

    constexpr int32 PURCHASE_UNKNOWN_ERROR = 4999;

    //----------------------------------------
    //  Push
    //----------------------------------------
    constexpr int32 PUSH_EXTERNAL_LIBRARY_ERROR = 5101;
    constexpr int32 PUSH_ALREADY_IN_PROGRESS_ERROR = 5102;

    constexpr int32 PUSH_UNKNOWN_ERROR = 5999;

    //----------------------------------------
    //  Logger
    //----------------------------------------
    constexpr int32 LOGGER_NOT_INITIALIZED = 6001;
    
    constexpr int32 LOGGER_EXTERNAL_LIBRARY_ERROR = 6048;
    
    constexpr int32 LOGGER_UNKNOWN_ERROR = 6049;
    
    //----------------------------------------
    //  UI
    //----------------------------------------
    constexpr int32 UI_IMAGE_NOTICE_TIMEOUT = 6901;
    constexpr int32 UI_IMAGE_NOTICE_NOT_SUPPORTED_OS = 6902;
    
    constexpr int32 UI_CONTACT_FAIL_INVALID_URL = 6911;
    constexpr int32 UI_CONTACT_FAIL_ISSUE_SHORT_TERM_TICKET = 6912;
    constexpr int32 UI_CONTACT_FAIL_ANDROID_DUPLICATED_VIEW = 6913;
    
    constexpr int32 UI_TERMS_NOT_EXIST_IN_CONSOLE = 6921;
    constexpr int32 UI_TERMS_NOT_EXIST_FOR_DEVICE_COUNTRY = 6922;
    constexpr int32 UI_TERMS_UNREGISTERED_SEQ = 6923;
    constexpr int32 UI_TERMS_ALREADY_IN_PROGRESS_ERROR = 6924;
    constexpr int32 UI_TERMS_ANDROID_DUPLICATED_VIEW = 6925;
    
    constexpr int32 UI_COMMUNITY_FAIL_INVALID_URL = 6931;
    constexpr int32 UI_COMMUNITY_FAIL_ISSUE_SHORT_TERM_TICKET = 6932;
    constexpr int32 UI_COMMUNITY_FAIL_ANDROID_DUPLICATED_VIEW = 6933;
    
    constexpr int32 UI_UNKNOWN_ERROR = 6999;

    //----------------------------------------
    //  Webview
    //----------------------------------------
    constexpr int32 WEBVIEW_INVALID_URL = 7001;
    constexpr int32 WEBVIEW_TIMEOUT = 7002;
    constexpr int32 WEBVIEW_HTTP_ERROR = 7003;
    constexpr int32 WEBVIEW_OPENED_NEW_BROWSER_BEFORE_CLOSE = 7004;
    
    constexpr int32 WEBVIEW_UNKNOWN_ERROR = 7999;

    //----------------------------------------
    //  Server
    //----------------------------------------
    constexpr int32 SERVER_INTERNAL_ERROR = 8001;
    constexpr int32 SERVER_REMOTE_SYSTEM_ERROR = 8002;
    constexpr int32 SERVER_INVALID_RESPONSE = 8003;

    constexpr int32 SERVER_UNKNOWN_ERROR = 8999;

    //----------------------------------------
    //  Unknown error
    //----------------------------------------
    constexpr int32 UNKNOWN_ERROR = 9999;
    
    //----------------------------------------
    //  Platform specified errors (iOS)
    //----------------------------------------
    constexpr int32 INVALID_INTERNAL_STATE = 11001;
    constexpr int32 NOT_CALLABLE_STATE = 11002;

    //----------------------------------------
    //  Platform specified errors (Unreal)
    //----------------------------------------
    constexpr int32 UNREAL_GET_ENGINE_INFO_ERROR = 12001;
    constexpr int32 NATIVE_METHOD_CALL_EXCEPTION_IN_PLUGIN = 12002;
}