#pragma once

#include "Serialization/JsonSerializerMacros.h"

#define BEGIN_GAMEBASE_VO_SERIALIZER \
        if (!bFlatObject) { Serializer.StartObject(); }

#define END_GAMEBASE_VO_SERIALIZER \
        if (!bFlatObject) { Serializer.EndObject(); }


#define GAMEBASE_VO_SERIALIZE(JsonName, JsonValue) \
        Serializer.Serialize(TEXT(JsonName), JsonValue)

#define GAMEBASE_JSON_SERIALIZE_ENUM_INDEX(JsonName, JsonValue, ElementType) \
        uint32 JsonValueDummy; \
        Serializer.Serialize(TEXT(JsonName), JsonValueDummy); \
        JsonValue = static_cast<ElementType>(JsonValueDummy);

#define GAMEBASE_VO_SERIALIZE_OPTIONAL(JsonName, OptionalJsonValue) \
        if (Serializer.IsLoading()) \
        { \
            if (Serializer.GetObject()->HasField(TEXT(JsonName))) \
            { \
                Serializer.Serialize(TEXT(JsonName), OptionalJsonValue.Emplace()); \
            } \
        } \
        else \
        { \
            if (OptionalJsonValue.IsSet()) \
            { \
                Serializer.Serialize(TEXT(JsonName), OptionalJsonValue.GetValue()); \
            } \
        }

#define GAMEBASE_VO_SERIALIZE_OPTIONAL(JsonName, OptionalJsonValue) \
        if (Serializer.IsLoading()) \
        { \
            if (Serializer.GetObject()->HasField(TEXT(JsonName))) \
            { \
                Serializer.Serialize(TEXT(JsonName), OptionalJsonValue.Emplace()); \
            } \
        } \
        else \
        { \
            if (OptionalJsonValue.IsSet()) \
            { \
                Serializer.Serialize(TEXT(JsonName), OptionalJsonValue.GetValue()); \
            } \
        }

#define GAMEBASE_VO_SERIALIZE_IN(JsonName, JsonValue) \
        Serializer.Serialize(TEXT(JsonName), ResultType.JsonValue)

#define GAMEBASE_VO_SERIALIZE_OPTIONAL_IN(JsonName, OptionalJsonValue) \
        if (Serializer.IsLoading()) \
        { \
            if (Serializer.GetObject()->HasField(TEXT(JsonName))) \
            { \
                Serializer.Serialize(TEXT(JsonName), OptionalJsonValue.Emplace()); \
            } \
        } \
        else \
        { \
            if (OptionalJsonValue.IsSet()) \
            { \
                Serializer.Serialize(TEXT(JsonName), OptionalJsonValue.GetValue()); \
            } \
        }

#define GAMEBASE_VO_SERIALIZE_COLOR(JsonName, JsonColor) \
        { \
            FLinearColor LinearColor = JsonColor.ReinterpretAsLinear(); \
            if (Serializer.IsLoading()) \
            { \
                if (Serializer.GetObject()->HasTypedField<EJson::Object>(JsonName)) \
                { \
                    TSharedPtr<FJsonObject> JsonObj = Serializer.GetObject()->GetObjectField(JsonName); \
                    if (JsonObj.IsValid()) \
                    { \
                        FJsonSerializerReader InnerSerializer(JsonObj); \
                        InnerSerializer.Serialize(TEXT("r"), LinearColor.R); \
                        InnerSerializer.Serialize(TEXT("g"), LinearColor.G); \
                        InnerSerializer.Serialize(TEXT("b"), LinearColor.B); \
                        InnerSerializer.Serialize(TEXT("a"), LinearColor.A); \
                    } \
                } \
            } \
            else \
            { \
                Serializer.StartObject(JsonName); \
                Serializer.Serialize(TEXT("r"), LinearColor.R); \
                Serializer.Serialize(TEXT("g"), LinearColor.G); \
                Serializer.Serialize(TEXT("b"), LinearColor.B); \
                Serializer.Serialize(TEXT("a"), LinearColor.A); \
                Serializer.EndObject(); \
            } \
        }

#define GAMEBASE_VO_SERIALIZE_COLOR_OPTIONAL(JsonName, JsonColor) \
        { \
            if (Serializer.IsLoading()) \
            { \
                if (Serializer.GetObject()->HasTypedField<EJson::Object>(JsonName)) \
                { \
                    TSharedPtr<FJsonObject> JsonObj = Serializer.GetObject()->GetObjectField(JsonName); \
                    if (JsonObj.IsValid()) \
                    { \
                        FJsonSerializerReader InnerSerializer(JsonObj); \
                        FLinearColor LinearColor = JsonColor.Emplace().ReinterpretAsLinear(); \
                        InnerSerializer.Serialize(TEXT("r"), LinearColor.R); \
                        InnerSerializer.Serialize(TEXT("g"), LinearColor.G); \
                        InnerSerializer.Serialize(TEXT("b"), LinearColor.B); \
                        InnerSerializer.Serialize(TEXT("a"), LinearColor.A); \
                    } \
                } \
            } \
            else \
            { \
                if (JsonColor.IsSet()) \
                { \
                    FLinearColor LinearColor = JsonColor.GetValue().ReinterpretAsLinear(); \
                    Serializer.StartObject(JsonName); \
                    Serializer.Serialize(TEXT("r"), LinearColor.R); \
                    Serializer.Serialize(TEXT("g"), LinearColor.G); \
                    Serializer.Serialize(TEXT("b"), LinearColor.B); \
                    Serializer.Serialize(TEXT("a"), LinearColor.A); \
                    Serializer.EndObject(); \
                } \
            } \
        }

#define GAMEBASE_VO_SERIALIZE_MAP(JsonName, JsonMap) \
        JSON_SERIALIZE_MAP(JsonName, JsonMap)

#define GAMEBASE_VO_SERIALIZE_MAP_IN(JsonName, JsonMap) \
        Serializer.SerializeMap(TEXT(JsonName), ResultType.JsonMap)


#define GAMEBASE_VO_SERIALIZE_ARRAY(JsonName, JsonArray) \
        JSON_SERIALIZE_ARRAY(JsonName, JsonArray)

#define GAMEBASE_VO_SERIALIZE_ARRAY_IN(JsonName, JsonArray) \
        Serializer.SerializeArray(TEXT(JsonName), ResultType.JsonArray)

#define GAMEBASE_VO_SERIALIZE_ARRAY_SERIALIZABLE(JsonName, JsonArray, ElementType) \
        if (Serializer.IsLoading()) \
        { \
            if (Serializer.GetObject()->HasTypedField<EJson::Array>(JsonName)) \
            { \
                for (auto It = Serializer.GetObject()->GetArrayField(JsonName).CreateConstIterator(); It; ++It) \
                { \
                    ElementType* Obj = new(JsonArray) ElementType(); \
                    Obj->FromJson((*It)->AsObject()); \
                } \
            } \
        } \
        else \
        { \
            Serializer.StartArray(JsonName); \
            for (auto It = JsonArray.CreateIterator(); It; ++It) \
            { \
                It->Serialize(Serializer, false); \
            } \
            Serializer.EndArray(); \
        }

#define GAMEBASE_VO_SERIALIZE_ARRAY_SERIALIZABLE_INNER(JsonName, JsonArray, ElementType, JsonObjectSerializer) \
        if (Serializer.IsLoading()) \
        { \
            if (Serializer.GetObject()->HasTypedField<EJson::Array>(JsonName)) \
            { \
                for (auto It = Serializer.GetObject()->GetArrayField(JsonName).CreateConstIterator(); It; ++It) \
                { \
                    ElementType* Obj = new(JsonArray) ElementType(); \
                    if ((*It)->AsObject().IsValid()) \
                    { \
                        FJsonSerializerReader InnerSerializer((*It)->AsObject()); \
                        JsonObjectSerializer(*Obj, InnerSerializer, false); \
                    } \
                } \
            } \
        } \
        else \
        { \
            Serializer.StartArray(JsonName); \
            for (auto It = JsonArray.CreateIterator(); It; ++It) \
            { \
                JsonObjectSerializer(*It, Serializer, false); \
            } \
            Serializer.EndArray(); \
        }

#define GAMEBASE_VO_SERIALIZE_MAP_SERIALIZABLE_INNER(JsonName, JsonMap, ElementType, JsonObjectSerializer) \
        if (Serializer.IsLoading()) \
        { \
            if (Serializer.GetObject()->HasTypedField<EJson::Object>(JsonName)) \
            { \
                TSharedPtr<FJsonObject> JsonObj = Serializer.GetObject()->GetObjectField(JsonName); \
                for (auto MapIt = JsonObj->Values.CreateConstIterator(); MapIt; ++MapIt) \
                { \
                    ElementType NewEntry; \
                    if (MapIt.Value()->AsObject().IsValid()) \
                    { \
                        FJsonSerializerReader InnerSerializer(MapIt.Value()->AsObject()); \
                        JsonObjectSerializer(NewEntry, InnerSerializer, false); \
                    } \
                    JsonMap.Add(MapIt.Key(), NewEntry); \
                } \
            } \
        } \
        else \
        { \
            Serializer.StartObject(JsonName); \
            for (auto It = JsonMap.CreateIterator(); It; ++It) \
            { \
                Serializer.StartObject(It.Key()); \
                JsonObjectSerializer(It.Value(), Serializer, true); \
                Serializer.EndObject(); \
            } \
            Serializer.EndObject(); \
        }



#define GAMEBASE_VO_SERIALIZE_OBJECT_SERIALIZABLE(JsonName, JsonSerializableObject) \
        JSON_SERIALIZE_OBJECT_SERIALIZABLE(JsonName, JsonSerializableObject)

#define GAMEBASE_VO_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE_INNER(JsonName, JsonSerializableObject, JsonObjectSerializer) \
        if (Serializer.IsLoading()) \
        { \
            using ObjectType = TRemoveReference<decltype(JsonSerializableObject.GetValue())>::Type; \
            if (Serializer.GetObject()->HasTypedField<EJson::Object>(JsonName)) \
            { \
                TSharedPtr<FJsonObject> JsonObj = Serializer.GetObject()->GetObjectField(JsonName); \
                if (JsonObj.IsValid()) \
                { \
                    FJsonSerializerReader InnerSerializer(JsonObj); \
                    JsonSerializableObject = ObjectType{}; \
                    JsonObjectSerializer(JsonSerializableObject.GetValue(), InnerSerializer, false); \
                } \
            } \
        } \
        else \
        { \
            if (JsonSerializableObject.IsSet()) \
            { \
                Serializer.StartObject(JsonName); \
                JsonObjectSerializer(JsonSerializableObject.GetValue(), Serializer, true); \
                Serializer.EndObject(); \
            } \
        }

#define GAMEBASE_VO_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE_INNER_VO(JsonName, JsonSerializableObject) \
        if (Serializer.IsLoading()) \
        { \
            using ObjectType = TRemoveReference<decltype(JsonSerializableObject.GetValue())>::Type; \
            if (Serializer.GetObject()->HasTypedField<EJson::Object>(JsonName)) \
            { \
                TSharedPtr<FJsonObject> JsonObj = Serializer.GetObject()->GetObjectField(JsonName); \
                if (JsonObj.IsValid()) \
                { \
                    FJsonSerializerReader InnerSerializer(JsonObj); \
                    JsonSerializableObject = ObjectType{}; \
                    JsonSerializableObject.GetValue().Serialize(InnerSerializer, false); \
                } \
            } \
        } \
        else \
        { \
            if (JsonSerializableObject.IsSet()) \
            { \
                Serializer.StartObject(JsonName); \
                JsonSerializableObject.GetValue().Serialize(Serializer, true); \
                Serializer.EndObject(); \
            } \
        }


#define GAMEBASE_VO_SERIALIZE_OBJECT_SERIALIZABLE_INNER(JsonName, JsonSerializableObject, JsonObjectSerializer) \
        /* Process the JsonName field differently because it is an object */ \
        if (Serializer.IsLoading()) \
        { \
            /* Read in the value from the JsonName field */ \
            if (Serializer.GetObject()->HasTypedField<EJson::Object>(JsonName)) \
            { \
                TSharedPtr<FJsonObject> JsonObj = Serializer.GetObject()->GetObjectField(JsonName); \
                if (JsonObj.IsValid()) \
                { \
                    FJsonSerializerReader InnerSerializer(JsonObj); \
                    JsonObjectSerializer(JsonSerializableObject, InnerSerializer, false); \
                } \
            } \
        } \
        else \
        { \
            /* Write the value to the Name field */ \
            Serializer.StartObject(JsonName); \
            JsonObjectSerializer(JsonSerializableObject, Serializer, true); \
            Serializer.EndObject(); \
        }

#define GAMEBASE_VO_SERIALIZE_OPTIONAL_MAP(JsonName, OptionalJsonMap) \
    if (Serializer.IsLoading()) \
    { \
        if (Serializer.GetObject()->HasTypedField<EJson::Object>(JsonName)) \
        { \
            TSharedPtr<FJsonObject> JsonObj = Serializer.GetObject()->GetObjectField(JsonName); \
            if (JsonObj.IsValid()) \
            { \
                OptionalJsonMap.Emplace(); \
                for (auto It = JsonObj->Values.CreateConstIterator(); It; ++It) \
                { \
                    OptionalJsonMap.GetValue().Add(It.Key(), It.Value()->AsString()); \
                } \
            } \
        } \
    } \
    else \
    { \
        if (OptionalJsonMap.IsSet()) \
        { \
            Serializer.StartObject(JsonName); \
            for (auto It = OptionalJsonMap.GetValue().CreateConstIterator(); It; ++It) \
            { \
                FString ValueCopy = It.Value(); \
                Serializer.Serialize(*It.Key(), ValueCopy); \
            } \
            Serializer.EndObject(); \
        } \
    }

#define GAMEBASE_VO_SERIALIZE_PTR_OBJECT_THREADSAFE(JsonName, PtrField, Type) \
    GAMEBASE_VO_SERIALIZE_PTR_OBJECT(JsonName, PtrField, Type, ESPMode::ThreadSafe)

#define GAMEBASE_VO_SERIALIZE_PTR_OBJECT(JsonName, PtrField, Type, ESPModeType) \
    if (Serializer.IsLoading()) \
    { \
        if (Serializer.GetObject()->HasTypedField<EJson::Object>(TEXT(JsonName))) \
        { \
            const TSharedPtr<FJsonObject> JsonObj = Serializer.GetObject()->GetObjectField(TEXT(JsonName)); \
            if (JsonObj.IsValid()) \
            { \
                PtrField = MakeShared<Type, ESPModeType>(); \
                FJsonSerializerReader InnerSerializer(JsonObj); \
                PtrField->Serialize(InnerSerializer, false); \
            } \
        } \
    } \
    else \
    { \
        if (PtrField.IsValid()) \
        { \
            Serializer.StartObject(TEXT(JsonName)); \
            PtrField->Serialize(Serializer, true); \
            Serializer.EndObject(); \
        } \
    }

#define GAMEBASE_VO_SERIALIZE_VARIANT_MAP(JsonName, VariantMap) \
    if (Serializer.IsLoading()) \
    { \
        if (Serializer.GetObject()->HasTypedField<EJson::Object>(JsonName)) \
        { \
            TSharedPtr<FJsonObject> JsonObj = Serializer.GetObject()->GetObjectField(JsonName); \
            if (JsonObj.IsValid()) \
            { \
                VariantMap = FGamebaseVariantMap(); \
                for (auto It = JsonObj->Values.CreateConstIterator(); It; ++It) \
                { \
                    VariantMap.Add(FName(It.Key()), FGamebaseVariant(It.Value()->AsString())); \
                } \
            } \
        } \
    } \
    else \
    { \
        Serializer.StartObject(JsonName); \
        for (auto It = VariantMap.GetMap().CreateConstIterator(); It; ++It) \
        { \
            FString ValueStr = It.Value().GetValue<FString>(); \
            Serializer.Serialize(*It.Key().ToString(), ValueStr); \
        } \
        Serializer.EndObject(); \
    }

#define GAMEBASE_VO_SERIALIZE_OPTIONAL_VARIANT_MAP(JsonName, OptionalVariantMap) \
    if (Serializer.IsLoading()) \
    { \
        if (Serializer.GetObject()->HasTypedField<EJson::Object>(JsonName)) \
        { \
            TSharedPtr<FJsonObject> JsonObj = Serializer.GetObject()->GetObjectField(JsonName); \
            if (JsonObj.IsValid()) \
            { \
                OptionalVariantMap.Emplace(); \
                for (auto It = JsonObj->Values.CreateConstIterator(); It; ++It) \
                { \
                    OptionalVariantMap.GetValue().Add(FName(It.Key()), FGamebaseVariant(It.Value()->AsString())); \
                } \
            } \
        } \
    } \
    else \
    { \
        if (OptionalVariantMap.IsSet()) \
        { \
            Serializer.StartObject(JsonName); \
            for (auto It = OptionalVariantMap.GetValue().GetMap().CreateConstIterator(); It; ++It) \
            { \
                FString ValueStr = It.Value().GetValue<FString>(); \
                Serializer.Serialize(*It.Key().ToString(), ValueStr); \
            } \
            Serializer.EndObject(); \
        } \
    }
