#include "GamebaseValueObject.h"

#include "Serialization/JsonSerializerMacros.h"

FString FGamebaseValueObject::ToJson()
{
    FString JsonStr;
    {
        TSharedRef<TJsonWriter<TCHAR, TCondensedJsonPrintPolicy<TCHAR>>> JsonWriter = TJsonWriterFactory<TCHAR, TCondensedJsonPrintPolicy<TCHAR>>::Create(&JsonStr);
        FJsonSerializerWriter<TCHAR, TCondensedJsonPrintPolicy<TCHAR>> Serializer(JsonWriter);
        Serialize(Serializer, false);
        JsonWriter->Close();
    }
    return JsonStr;
}

FString FGamebaseValueObject::ToPrettyJson()
{
    FString JsonStr;
    {
        TSharedRef<TJsonWriter<>> JsonWriter = TJsonWriterFactory<>::Create(&JsonStr);
        FJsonSerializerWriter<> Serializer(JsonWriter);
        Serialize(Serializer, false);
        JsonWriter->Close();
    }
    return JsonStr;
}

FString FGamebaseValueObject::ToJson() const
{
    return const_cast<FGamebaseValueObject*>(this)->ToJson();
}

FString FGamebaseValueObject::ToPrettyJson() const
{
    return const_cast<FGamebaseValueObject*>(this)->ToPrettyJson();
}

bool FGamebaseValueObject::FromJson(const FString& Json)
{
    return FromJson(CopyTemp(Json));
}

bool FGamebaseValueObject::FromJson(FString&& Json)
{
    TSharedPtr<FJsonObject> JsonObject;
    TSharedRef<TJsonReader<>> JsonReader = TJsonReaderFactory<>::Create(MoveTemp(Json));
    if (FJsonSerializer::Deserialize(JsonReader,JsonObject) && JsonObject.IsValid())
    {
        FJsonSerializerReader Serializer(JsonObject);
        Serialize(Serializer, false);
        return true;
    }
    return false;
}

bool FGamebaseValueObject::FromJson(TSharedPtr<FJsonObject> JsonObject)
{
    if (JsonObject.IsValid())
    {
        FJsonSerializerReader Serializer(JsonObject);
        Serialize(Serializer, false);
        return true;
    }
    return false;
}
