#include "GamebaseWebViewTypes.h"

#include "Utilities/GamebaseValueObjectSerializerMacros.h"

void FGamebaseWebViewConfiguration::Serialize(FJsonSerializerBase& Serializer, bool bFlatObject)
{
    BEGIN_GAMEBASE_VO_SERIALIZER
    GAMEBASE_VO_SERIALIZE("title", Title);
    GAMEBASE_VO_SERIALIZE("orientation", Orientation);
    GAMEBASE_VO_SERIALIZE_COLOR("navigationColor", NavigationColor);
    GAMEBASE_VO_SERIALIZE_COLOR("navigationTitleColor", NavigationTitleColor);
    GAMEBASE_VO_SERIALIZE_COLOR_OPTIONAL("navigationIconTintColor", NavigationIconTintColor);
    GAMEBASE_VO_SERIALIZE("barHeight", NavigationBarHeight);
    GAMEBASE_VO_SERIALIZE("isBackButtonVisible", bIsBackButtonVisible);
    GAMEBASE_VO_SERIALIZE("isNavigationBarVisible", bIsNavigationBarVisible);
    GAMEBASE_VO_SERIALIZE("backButtonImageResource", BackButtonImageResource);
    GAMEBASE_VO_SERIALIZE("closeButtonImageResource", CloseButtonImageResource);
    GAMEBASE_VO_SERIALIZE("contentMode", ContentMode);
    GAMEBASE_VO_SERIALIZE("enableFixedFontSize", bEnableFixedFontSize);
    GAMEBASE_VO_SERIALIZE("renderOutsideSafeArea", bRenderOutsideSafeArea);
    GAMEBASE_VO_SERIALIZE_COLOR_OPTIONAL("cutoutColor", CutoutColor);
    END_GAMEBASE_VO_SERIALIZER
}
