﻿#include "GamebaseTermsTypes.h"

#include "Utilities/GamebaseValueObjectSerializerMacros.h"

void FGamebaseTermsConfiguration::Serialize(FJsonSerializerBase& Serializer, bool bFlatObject)
{
    BEGIN_GAMEBASE_VO_SERIALIZER
    GAMEBASE_VO_SERIALIZE("forceShow", bForceShow);
    GAMEBASE_VO_SERIALIZE("enableFixedFontSize", bEnableFixedFontSize);
    END_GAMEBASE_VO_SERIALIZER
}

void FGamebaseTermsContent::Serialize(FJsonSerializerBase& Serializer, bool bFlatObject)
{
    BEGIN_GAMEBASE_VO_SERIALIZER
    GAMEBASE_VO_SERIALIZE("termsContentSeq", TermsContentSeq);
    GAMEBASE_VO_SERIALIZE("agreed", bAgreed);
    END_GAMEBASE_VO_SERIALIZER
}

void FGamebaseUpdateTermsConfiguration::Serialize(FJsonSerializerBase& Serializer, bool bFlatObject)
{
    BEGIN_GAMEBASE_VO_SERIALIZER
    GAMEBASE_VO_SERIALIZE("termsSeq", TermsSeq);
    GAMEBASE_VO_SERIALIZE("termsVersion", TermsVersion);
    GAMEBASE_VO_SERIALIZE_ARRAY_SERIALIZABLE("contents", Contents, FGamebaseTermsContent);
    END_GAMEBASE_VO_SERIALIZER
}

void FGamebaseQueryTermsResult::Serialize(FJsonSerializerBase& Serializer, bool bFlatObject)
{
    auto ContentSerialize = [](FContentDetail& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
    {
        BEGIN_GAMEBASE_VO_SERIALIZER
        GAMEBASE_VO_SERIALIZE_IN("termsContentSeq", TermsContentSeq);
        GAMEBASE_VO_SERIALIZE_IN("agreed", bAgreed);
        GAMEBASE_VO_SERIALIZE_IN("required", bRequired);
        GAMEBASE_VO_SERIALIZE_IN("name", Name);
        GAMEBASE_VO_SERIALIZE_IN("agreePush", AgreePush);
        GAMEBASE_VO_SERIALIZE_IN("node1DepthPosition", Node1DepthPosition);
        GAMEBASE_VO_SERIALIZE_IN("node2DepthPosition", Node2DepthPosition);
        GAMEBASE_VO_SERIALIZE_IN("detailPageUrl", DetailPageUrl);
        END_GAMEBASE_VO_SERIALIZER
    };

    BEGIN_GAMEBASE_VO_SERIALIZER
    GAMEBASE_VO_SERIALIZE("termsVersion", TermsVersion);
    GAMEBASE_VO_SERIALIZE("termsSeq", TermsSeq);
    GAMEBASE_VO_SERIALIZE("termsCountryType", TermsCountryType);
    GAMEBASE_VO_SERIALIZE_ARRAY_SERIALIZABLE_INNER("contents", Contents, FContentDetail, ContentSerialize);
    END_GAMEBASE_VO_SERIALIZER
}

FGamebaseShowTermsViewResultPtr FGamebaseShowTermsViewResult::From(const FGamebaseDataContainer* DataContainer)
{
    if (DataContainer == nullptr || DataContainer->Data.IsEmpty())
    {
        return nullptr;
    }

    const FGamebaseShowTermsViewResultPtr ShowTermsViewResult = MakeShared<FGamebaseShowTermsViewResult, ESPMode::ThreadSafe>();
    ShowTermsViewResult->FromJson(DataContainer->Data);
    
    return ShowTermsViewResult;
}

void FGamebaseShowTermsViewResult::Serialize(FJsonSerializerBase& Serializer, bool bFlatObject)
{
    BEGIN_GAMEBASE_VO_SERIALIZER
    GAMEBASE_VO_SERIALIZE("isTermsUIOpened", bIsTermsUIOpened);
    END_GAMEBASE_VO_SERIALIZER
}
