#include "GamebasePurchaseTypes.h"

#include "Utilities/GamebaseValueObjectSerializerMacros.h"

void FGamebasePurchasableConfiguration::Serialize(FJsonSerializerBase& Serializer, bool bFlatObject)
{
    BEGIN_GAMEBASE_VO_SERIALIZER
    GAMEBASE_VO_SERIALIZE("allStores", bAllStores);
    GAMEBASE_VO_SERIALIZE("includeExpiredSubscriptions", bIncludeExpiredSubscriptions);
    END_GAMEBASE_VO_SERIALIZER
}

void FGamebasePurchasableItem::Serialize(FJsonSerializerBase& Serializer, bool bFlatObject)
{
    BEGIN_GAMEBASE_VO_SERIALIZER
    GAMEBASE_VO_SERIALIZE("gamebaseProductId", GamebaseProductId);
    GAMEBASE_VO_SERIALIZE("itemSeq", ItemSeq);
    GAMEBASE_VO_SERIALIZE("price", Price);
    GAMEBASE_VO_SERIALIZE("currency", Currency);
    GAMEBASE_VO_SERIALIZE("itemName", ItemName);
    GAMEBASE_VO_SERIALIZE("marketItemId", MarketItemId);
    GAMEBASE_VO_SERIALIZE("productType", ProductType);
    GAMEBASE_VO_SERIALIZE("localizedPrice", LocalizedPrice);
    GAMEBASE_VO_SERIALIZE("localizedTitle", LocalizedTitle);
    GAMEBASE_VO_SERIALIZE("localizedDescription", LocalizedDescription);
    GAMEBASE_VO_SERIALIZE("isActive", bIsActive);
    END_GAMEBASE_VO_SERIALIZER
}

void FGamebasePurchasableReceipt::Serialize(FJsonSerializerBase& Serializer, bool bFlatObject)
{
    BEGIN_GAMEBASE_VO_SERIALIZER
    GAMEBASE_VO_SERIALIZE("gamebaseProductId", GamebaseProductId);
    GAMEBASE_VO_SERIALIZE("itemSeq", ItemSeq);
    GAMEBASE_VO_SERIALIZE("price", Price);
    GAMEBASE_VO_SERIALIZE("currency", Currency);
    GAMEBASE_VO_SERIALIZE("paymentSeq", PaymentSeq);
    GAMEBASE_VO_SERIALIZE("purchaseToken", PurchaseToken);
    GAMEBASE_VO_SERIALIZE("marketItemId", MarketItemId);
    GAMEBASE_VO_SERIALIZE("productType", ProductType);
    GAMEBASE_VO_SERIALIZE("userId", UserId);
    GAMEBASE_VO_SERIALIZE("paymentId", PaymentId);
    GAMEBASE_VO_SERIALIZE_OPTIONAL("originalPaymentId", OriginalPaymentId);
    GAMEBASE_VO_SERIALIZE("purchaseTime", PurchaseTime);
    GAMEBASE_VO_SERIALIZE("expiryTime", ExpiryTime);
    GAMEBASE_VO_SERIALIZE("storeCode", StoreCode);
    GAMEBASE_VO_SERIALIZE_OPTIONAL("payload", Payload);
    GAMEBASE_VO_SERIALIZE_OPTIONAL("isPromotion", bIsPromotion);
    GAMEBASE_VO_SERIALIZE_OPTIONAL("isTestPurchase", bIsTestPurchase);
    END_GAMEBASE_VO_SERIALIZER
}

void FGamebasePurchasableSubscriptionStatus::Serialize(FJsonSerializerBase& Serializer, bool bFlatObject)
{
    BEGIN_GAMEBASE_VO_SERIALIZER
    GAMEBASE_VO_SERIALIZE("gamebaseProductId", GamebaseProductId);
    GAMEBASE_VO_SERIALIZE("itemSeq", ItemSeq);
    GAMEBASE_VO_SERIALIZE("storeCode", StoreCode);
    GAMEBASE_VO_SERIALIZE("paymentId", PaymentId);
    GAMEBASE_VO_SERIALIZE_OPTIONAL("originalPaymentId", OriginalPaymentId);
    GAMEBASE_VO_SERIALIZE("paymentSeq", PaymentSeq);
    GAMEBASE_VO_SERIALIZE("marketItemId", MarketItemId);
    GAMEBASE_VO_SERIALIZE("productType", ProductType);
    GAMEBASE_VO_SERIALIZE("userId", UserId);
    GAMEBASE_VO_SERIALIZE("price", Price);
    GAMEBASE_VO_SERIALIZE("currency", Currency);
    GAMEBASE_VO_SERIALIZE("purchaseToken", PurchaseToken);
    GAMEBASE_VO_SERIALIZE("purchaseTime", PurchaseTime);
    GAMEBASE_VO_SERIALIZE("expiryTime", ExpiryTime);
    GAMEBASE_VO_SERIALIZE("statusCode", StatusCode);
    GAMEBASE_VO_SERIALIZE("statusDescription", StatusDescription);
    GAMEBASE_VO_SERIALIZE_OPTIONAL("payload", Payload);
    GAMEBASE_VO_SERIALIZE_OPTIONAL("purchaseType", PurchaseType);
    END_GAMEBASE_VO_SERIALIZER
}
