#include "GamebaseLoggerTypes.h"

#include "Utilities/GamebaseValueObjectSerializerMacros.h"

void FGamebaseLoggerConfiguration::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_GAMEBASE_VO_SERIALIZER
    GAMEBASE_VO_SERIALIZE("appKey", AppKey);
    GAMEBASE_VO_SERIALIZE("enableCrashReporter", bEnableCrashReporter);
    GAMEBASE_VO_SERIALIZE("zoneType", ZoneType);
    END_GAMEBASE_VO_SERIALIZER
}

void FGamebaseLogEntry::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    int32 ConvertLogLevel = static_cast<int32>(LogLevel);
    
    BEGIN_GAMEBASE_VO_SERIALIZER
    GAMEBASE_VO_SERIALIZE("logType", LogType);
    GAMEBASE_VO_SERIALIZE("logLevel", ConvertLogLevel);
    GAMEBASE_VO_SERIALIZE("transactionId", TransactionId);
    GAMEBASE_VO_SERIALIZE("createTime", CreateTime);
    GAMEBASE_VO_SERIALIZE_MAP("userFields", UserFields);
    END_GAMEBASE_VO_SERIALIZER
}

void FGamebaseLogFilter::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_GAMEBASE_VO_SERIALIZER
    GAMEBASE_VO_SERIALIZE("name", Name);
    END_GAMEBASE_VO_SERIALIZER
}

void FGamebaseLoggerEngineCrashData::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    int32 ConvertLogLevel = static_cast<int32>(LogLevel);
    
    BEGIN_GAMEBASE_VO_SERIALIZER
    GAMEBASE_VO_SERIALIZE("logLevel", ConvertLogLevel);
    GAMEBASE_VO_SERIALIZE("condition", Condition);
    GAMEBASE_VO_SERIALIZE("stackTrace", StackTrace);
    END_GAMEBASE_VO_SERIALIZER
}