#include "GamebaseLaunchingTypes.h"

#include "Utilities/GamebaseValueObjectSerializerMacros.h"

namespace GamebaseErrorExtras
{
    const FString UpdateInfo{ TEXT("updateInfo") };
}

FGamebaseLaunchingUpdateInfoPtr FGamebaseLaunchingUpdateInfo::From(const FGamebaseError* Error)
{
    if (Error == nullptr)
    {
        return nullptr;
    }
    
    const TOptional<FString>& JsonString = Error->FindExtra(GamebaseErrorExtras::UpdateInfo);
    if (!JsonString.IsSet())
    {
        return nullptr;
    }
    
    const FGamebaseLaunchingUpdateInfoPtr LaunchingUpdateInfo = MakeShared<FGamebaseLaunchingUpdateInfo, ESPMode::ThreadSafe>();
    LaunchingUpdateInfo->FromJson(JsonString.GetValue());
    
    return LaunchingUpdateInfo;
}

void FGamebaseLaunchingUpdateInfo::Serialize(FJsonSerializerBase& Serializer, bool bFlatObject)
{
    BEGIN_GAMEBASE_VO_SERIALIZER
    GAMEBASE_VO_SERIALIZE("installUrl", InstallUrl);
    GAMEBASE_VO_SERIALIZE("message", Message);
    GAMEBASE_VO_SERIALIZE("detailUrl", DetailUrl);
    END_GAMEBASE_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::Serialize(FJsonSerializerBase& Serializer, bool bFlatObject)
{
    auto LaunchingSerialize = [](FLaunching& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
    {
        auto StatusSerialize = [](FLaunching::FStatus& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
        {
            BEGIN_GAMEBASE_VO_SERIALIZER
            GAMEBASE_VO_SERIALIZE_IN("code", Code);
            GAMEBASE_VO_SERIALIZE_IN("message", Message);
            END_GAMEBASE_VO_SERIALIZER
        };
        
        auto AppSerialize = [](FLaunching::FApp& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
        {
            auto AccessInfoSerialize = [](FLaunching::FApp::FAccessInfo& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
            {
                BEGIN_GAMEBASE_VO_SERIALIZER
                GAMEBASE_VO_SERIALIZE_IN("serverAddress", ServerAddress);
                END_GAMEBASE_VO_SERIALIZER
            };

            auto IdpSerialize = [](FLaunching::FApp::FIdp& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
            {
                auto LoginWebViewSerialize = [](FLaunching::FApp::FIdp::FLoginWebView& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
                {
                    BEGIN_GAMEBASE_VO_SERIALIZER
                    GAMEBASE_VO_SERIALIZE_IN("titleBgColor", TitleBgColor);
                    GAMEBASE_VO_SERIALIZE_IN("titleTextColor", TitleTextColor);
                    GAMEBASE_VO_SERIALIZE_IN("title", Title);
                    END_GAMEBASE_VO_SERIALIZER
                };
                
                auto ChannelsSerialize = [](FLaunching::FApp::FIdp::FChannels& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
                {
                    BEGIN_GAMEBASE_VO_SERIALIZER
                    GAMEBASE_VO_SERIALIZE_IN("region", Region);
                    GAMEBASE_VO_SERIALIZE_IN("clientId", ClientId);
                    GAMEBASE_VO_SERIALIZE_IN("clientSecret", ClientSecret);
                    END_GAMEBASE_VO_SERIALIZER
                };

                BEGIN_GAMEBASE_VO_SERIALIZER
                GAMEBASE_VO_SERIALIZE_OPTIONAL("clientId", ResultType.ClientId);
                GAMEBASE_VO_SERIALIZE_OPTIONAL("clientSecret", ResultType.ClientSecret);
                GAMEBASE_VO_SERIALIZE_OPTIONAL("additional", ResultType.Additional);
                GAMEBASE_VO_SERIALIZE_OPTIONAL("callbackUrl", ResultType.CallbackUrl);
                GAMEBASE_VO_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE_INNER("loginWebView", ResultType.LoginWebView, LoginWebViewSerialize);
                GAMEBASE_VO_SERIALIZE_ARRAY_SERIALIZABLE_INNER("channels", ResultType.Channels, FLaunching::FApp::FIdp::FChannels, ChannelsSerialize);
                END_GAMEBASE_VO_SERIALIZER
            };
            
            auto InstallSerialize = [](FLaunching::FApp::FInstall& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
            {
                BEGIN_GAMEBASE_VO_SERIALIZER
                GAMEBASE_VO_SERIALIZE_IN("url", Url);
                GAMEBASE_VO_SERIALIZE_IN("detailUrl", DetailUrl);
                END_GAMEBASE_VO_SERIALIZER
            };
        
            auto RelatedUrlsSerialize = [](FLaunching::FApp::FRelatedUrls& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
            {
                BEGIN_GAMEBASE_VO_SERIALIZER
                GAMEBASE_VO_SERIALIZE_IN("termsUrl", TermsUrl);
                GAMEBASE_VO_SERIALIZE_IN("punishRuleUrl", PunishRuleUrl);
                GAMEBASE_VO_SERIALIZE_IN("personalInfoCollectionUrl", PersonalInfoCollectionUrl);
                END_GAMEBASE_VO_SERIALIZER
            };
            
            auto LanguageSerialize = [](FLaunching::FApp::FLanguage& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
            {
                BEGIN_GAMEBASE_VO_SERIALIZER
                GAMEBASE_VO_SERIALIZE_IN("deviceLanguage", DeviceLanguage);
                GAMEBASE_VO_SERIALIZE_IN("defaultLanguage", DefaultLanguage);
                END_GAMEBASE_VO_SERIALIZER
            };
            
            auto LoginUrlsSerialize = [](FLaunching::FApp::FLoginUrls& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
            {
                BEGIN_GAMEBASE_VO_SERIALIZER
                GAMEBASE_VO_SERIALIZE_IN("gamebaseUrl", GamebaseUrl);
                END_GAMEBASE_VO_SERIALIZER
            };
            
            auto CustomerServiceSerialize = [](FLaunching::FApp::FCustomerService& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
            {
                BEGIN_GAMEBASE_VO_SERIALIZER
                GAMEBASE_VO_SERIALIZE_IN("type", Type);
                GAMEBASE_VO_SERIALIZE_IN("url", Url);
                GAMEBASE_VO_SERIALIZE_IN("accessInfo", AccessInfo);
                END_GAMEBASE_VO_SERIALIZER
            };
            
            auto TermsServiceSerialize = [](FLaunching::FApp::FTermsService& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
            {
                BEGIN_GAMEBASE_VO_SERIALIZER
                GAMEBASE_VO_SERIALIZE_IN("showTermsFlag", bShowTermsFlag);
                GAMEBASE_VO_SERIALIZE_IN("termsUrl", TermsUrl);
                END_GAMEBASE_VO_SERIALIZER
            };

            auto GameNoticeSerialize = [](FLaunching::FApp::FGameNotice& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
            {
                BEGIN_GAMEBASE_VO_SERIALIZER
                GAMEBASE_VO_SERIALIZE_IN("url", Url);
                END_GAMEBASE_VO_SERIALIZER
            };

            BEGIN_GAMEBASE_VO_SERIALIZER
            GAMEBASE_VO_SERIALIZE_OBJECT_SERIALIZABLE_INNER("accessInfo", ResultType.AccessInfo, AccessInfoSerialize);
            GAMEBASE_VO_SERIALIZE_MAP_SERIALIZABLE_INNER("idP", ResultType.Idp, FLaunching::FApp::FIdp, IdpSerialize);
            GAMEBASE_VO_SERIALIZE_OBJECT_SERIALIZABLE_INNER("install", ResultType.Install, InstallSerialize);
            GAMEBASE_VO_SERIALIZE_OBJECT_SERIALIZABLE_INNER("relatedUrls", ResultType.RelatedUrls, RelatedUrlsSerialize)
            GAMEBASE_VO_SERIALIZE_OBJECT_SERIALIZABLE_INNER("language", ResultType.Language, LanguageSerialize);
            GAMEBASE_VO_SERIALIZE("storeCode", ResultType.StoreCode);
            GAMEBASE_VO_SERIALIZE("typeCode", ResultType.TypeCode);
            GAMEBASE_VO_SERIALIZE_OBJECT_SERIALIZABLE_INNER("loginUrls", ResultType.LoginUrls, LoginUrlsSerialize);
            GAMEBASE_VO_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE_INNER("customerService", ResultType.CustomerService, CustomerServiceSerialize);
            GAMEBASE_VO_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE_INNER("gameNotice", ResultType.GameNotice, GameNoticeSerialize);
            GAMEBASE_VO_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE_INNER("termsService", ResultType.TermsService, TermsServiceSerialize);
            END_GAMEBASE_VO_SERIALIZER
        };
        
        auto MaintenanceSerialize = [](FLaunching::FMaintenance& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
        {
            BEGIN_GAMEBASE_VO_SERIALIZER
            GAMEBASE_VO_SERIALIZE_IN("url", Url);
            GAMEBASE_VO_SERIALIZE_IN("typeCode", TypeCode);
            GAMEBASE_VO_SERIALIZE_IN("pageTypeCode", PageTypeCode);
            GAMEBASE_VO_SERIALIZE_IN("reason", Reason);
            GAMEBASE_VO_SERIALIZE_IN("message", Message);
            GAMEBASE_VO_SERIALIZE_IN("timezone", Timezone);
            GAMEBASE_VO_SERIALIZE_IN("beginDate", BeginDate);
            GAMEBASE_VO_SERIALIZE_IN("endDate", EndDate);
            GAMEBASE_VO_SERIALIZE_IN("localBeginDate", LocalBeginDate);
            GAMEBASE_VO_SERIALIZE_IN("localEndDate", LocalEndDate);
            GAMEBASE_VO_SERIALIZE_IN("hideDate", bHideDate);
            END_GAMEBASE_VO_SERIALIZER
        };
        
        auto NoticeSerialize = [](FLaunching::FNotice& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
        {
            BEGIN_GAMEBASE_VO_SERIALIZER
            GAMEBASE_VO_SERIALIZE_IN("message", Message);
            GAMEBASE_VO_SERIALIZE_IN("title", Title);
            GAMEBASE_VO_SERIALIZE_IN("url", Url);
            END_GAMEBASE_VO_SERIALIZER
        };

        auto FTcgbClientSerialize = [](FLaunching::FTcgbClient& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
        {
            auto StabilitySerialize = [](FLaunching::FTcgbClient::FStability& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
            {
                BEGIN_GAMEBASE_VO_SERIALIZER
                GAMEBASE_VO_SERIALIZE_IN("useFlag", bUseFlag);
                GAMEBASE_VO_SERIALIZE_IN("useFlagSpecificUser", bUseFlagSpecificUser);
                GAMEBASE_VO_SERIALIZE_IN("logLevel", LogLevel);
                GAMEBASE_VO_SERIALIZE_IN("appKey", AppKey);
                GAMEBASE_VO_SERIALIZE_IN("appKeyVersion", AppKeyVersion);
                GAMEBASE_VO_SERIALIZE_IN("initFailCount", InitFailCount);
                GAMEBASE_VO_SERIALIZE_ARRAY_IN("securityBlacklist", SecurityBlacklist);
                END_GAMEBASE_VO_SERIALIZER
            };
            
            auto ForceRemoteSettingsSerialize = [](FLaunching::FTcgbClient::FForceRemoteSettings& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
            {
                auto StabilitySerialize = [](FLaunching::FTcgbClient::FForceRemoteSettings::FLog& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
                {
                    BEGIN_GAMEBASE_VO_SERIALIZER
                    GAMEBASE_VO_SERIALIZE_IN("policy", Policy);
                    GAMEBASE_VO_SERIALIZE_IN("indicator", Indicator);
                    GAMEBASE_VO_SERIALIZE_IN("reason", Reason);
                    GAMEBASE_VO_SERIALIZE_IN("appKeyIndicator", AppKeyIndicator);
                    GAMEBASE_VO_SERIALIZE_IN("appKeyLog", AppKeyLog);
                    END_GAMEBASE_VO_SERIALIZER
                };
                
                BEGIN_GAMEBASE_VO_SERIALIZER
                GAMEBASE_VO_SERIALIZE_OBJECT_SERIALIZABLE_INNER("log", ResultType.Log, StabilitySerialize);
                END_GAMEBASE_VO_SERIALIZER
            };
            
            auto IntrospectionSerialize = [](FLaunching::FTcgbClient::FIntrospection& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
            {
                BEGIN_GAMEBASE_VO_SERIALIZER
                GAMEBASE_VO_SERIALIZE_IN("intervalSeconds", IntervalSeconds);
                END_GAMEBASE_VO_SERIALIZER
            };
            
            BEGIN_GAMEBASE_VO_SERIALIZER
            GAMEBASE_VO_SERIALIZE_OBJECT_SERIALIZABLE_INNER("stability", ResultType.Stability, StabilitySerialize);
            GAMEBASE_VO_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE_INNER("forceRemoteSettings", ResultType.ForceRemoteSettings, ForceRemoteSettingsSerialize);
            GAMEBASE_VO_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE_INNER("introspection", ResultType.Introspection, IntrospectionSerialize);
            END_GAMEBASE_VO_SERIALIZER
        };
        
        auto UserSerialize = [](FLaunching::FUser& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
        {
            auto TestDeviceSerialize = [](FLaunching::FUser::FTestDevice& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
            {
                BEGIN_GAMEBASE_VO_SERIALIZER
                GAMEBASE_VO_SERIALIZE_IN("matchingFlag", bMatchingFlag);
                GAMEBASE_VO_SERIALIZE_ARRAY_IN("matchingTypes", MatchingTypes);
                END_GAMEBASE_VO_SERIALIZER
            };
            
            BEGIN_GAMEBASE_VO_SERIALIZER
            GAMEBASE_VO_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE_INNER("testDevice", ResultType.TestDevice, TestDeviceSerialize);
            END_GAMEBASE_VO_SERIALIZER
        };
        BEGIN_GAMEBASE_VO_SERIALIZER
        
        GAMEBASE_VO_SERIALIZE_OBJECT_SERIALIZABLE_INNER("status", ResultType.Status, StatusSerialize);
        GAMEBASE_VO_SERIALIZE_OBJECT_SERIALIZABLE_INNER("app", ResultType.App, AppSerialize);
        GAMEBASE_VO_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE_INNER("user", ResultType.User, UserSerialize);
        GAMEBASE_VO_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE_INNER("maintenance", ResultType.Maintenance, MaintenanceSerialize);
        GAMEBASE_VO_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE_INNER("notice", ResultType.Notice, NoticeSerialize);
        GAMEBASE_VO_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE_INNER("tcgbClient", ResultType.TcgbClient, FTcgbClientSerialize);
        END_GAMEBASE_VO_SERIALIZER
    };
    
    auto TcProductInfoSerialize = [](FTcProductInfo& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
    {
        auto AppkeyInfoSerialize = [](FTcProductInfo::FAppKeyInfo& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
        {
            BEGIN_GAMEBASE_VO_SERIALIZER
            GAMEBASE_VO_SERIALIZE_IN("appKey", AppKey);
            END_GAMEBASE_VO_SERIALIZER
        };

        BEGIN_GAMEBASE_VO_SERIALIZER
        GAMEBASE_VO_SERIALIZE_OBJECT_SERIALIZABLE_INNER("gamebase", ResultType.Gamebase, AppkeyInfoSerialize);
        GAMEBASE_VO_SERIALIZE_OBJECT_SERIALIZABLE_INNER("tcLaunching", ResultType.TcLaunching, AppkeyInfoSerialize);
        GAMEBASE_VO_SERIALIZE_OBJECT_SERIALIZABLE_INNER("iap", ResultType.Iap, AppkeyInfoSerialize);
        GAMEBASE_VO_SERIALIZE_OBJECT_SERIALIZABLE_INNER("push", ResultType.Push, AppkeyInfoSerialize);
        END_GAMEBASE_VO_SERIALIZER
    };
    
    auto TcIapInfoSerialize = [](FTcIapInfo& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
    {
        BEGIN_GAMEBASE_VO_SERIALIZER
        GAMEBASE_VO_SERIALIZE_IN("id", Id);
        GAMEBASE_VO_SERIALIZE_IN("name", Name);
        GAMEBASE_VO_SERIALIZE_IN("storeCode", StoreCode);
        GAMEBASE_VO_SERIALIZE_IN("storeAppId", StoreAppId);
        END_GAMEBASE_VO_SERIALIZER
    };
    
    BEGIN_GAMEBASE_VO_SERIALIZER
    GAMEBASE_VO_SERIALIZE_OBJECT_SERIALIZABLE_INNER("launching", Launching, LaunchingSerialize);
    GAMEBASE_VO_SERIALIZE_OBJECT_SERIALIZABLE_INNER("tcProduct", TcProduct, TcProductInfoSerialize);
    GAMEBASE_VO_SERIALIZE_ARRAY_SERIALIZABLE_INNER("tcIap", TcIap, FTcIapInfo, TcIapInfoSerialize);
    GAMEBASE_VO_SERIALIZE_OPTIONAL("tcLaunching", TcLaunching);
    END_GAMEBASE_VO_SERIALIZER
}