#include "GamebaseEventTypes.h"

#include "Utilities/GamebaseValueObjectSerializerMacros.h"

void FGamebaseEventMessage::Serialize(FJsonSerializerBase& Serializer, bool bFlatObject)
{
    BEGIN_GAMEBASE_VO_SERIALIZER
    GAMEBASE_VO_SERIALIZE("category", Category);
    GAMEBASE_VO_SERIALIZE("data", Data);
    END_GAMEBASE_VO_SERIALIZER
}

FGamebaseEventServerPushDataPtr FGamebaseEventServerPushData::From(const FString& JsonString)
{
    if (JsonString.IsEmpty() == true)
    {
        return nullptr;
    }
    
    const FGamebaseEventServerPushDataPtr ServerPushData = MakeShared<FGamebaseEventServerPushData, ESPMode::ThreadSafe>();
    ServerPushData->FromJson(JsonString);
    
    return ServerPushData;
}

void FGamebaseEventServerPushData::Serialize(FJsonSerializerBase& Serializer, bool bFlatObject)
{
    auto PopupSerialize = [](FPopup& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
    {
        auto MessageSerialize = [](FPopup::FMessage& ResultType, FJsonSerializerBase& Serializer, bool bFlatObject)
        {
            BEGIN_GAMEBASE_VO_SERIALIZER
            GAMEBASE_VO_SERIALIZE_IN("message", Message);
            GAMEBASE_VO_SERIALIZE_IN("title", Title);
            END_GAMEBASE_VO_SERIALIZER
        };

        BEGIN_GAMEBASE_VO_SERIALIZER
        GAMEBASE_VO_SERIALIZE_IN("defaultLanguage", DefaultLanguage);
        GAMEBASE_VO_SERIALIZE_MAP_SERIALIZABLE_INNER("messages", ResultType.Messages, FPopup::FMessage, MessageSerialize);
        END_GAMEBASE_VO_SERIALIZER
    };
    
    BEGIN_GAMEBASE_VO_SERIALIZER
    GAMEBASE_VO_SERIALIZE("extras", Extras);
    GAMEBASE_VO_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE_INNER("popup", Popup, PopupSerialize);
    END_GAMEBASE_VO_SERIALIZER
}

FGamebaseEventObserverDataPtr FGamebaseEventObserverData::From(const FString& JsonString)
{
    if (JsonString.IsEmpty() == true)
    {
        return nullptr;
    }

    const FGamebaseEventObserverDataPtr ObserverData = MakeShared<FGamebaseEventObserverData, ESPMode::ThreadSafe>();
    ObserverData->FromJson(JsonString);
    
    return ObserverData;
}

void FGamebaseEventObserverData::Serialize(FJsonSerializerBase& Serializer, bool bFlatObject)
{
    BEGIN_GAMEBASE_VO_SERIALIZER
    GAMEBASE_VO_SERIALIZE("code", Code);
    GAMEBASE_VO_SERIALIZE("extras", Extras);
    GAMEBASE_VO_SERIALIZE("message", Message);
    END_GAMEBASE_VO_SERIALIZER
}

FGamebasePurchasableReceiptPtr FGamebaseEventPurchasableReceipt::From(const FString& JsonString)
{
    if (JsonString.IsEmpty() == true)
    {
        return nullptr;
    }
    
    const FGamebasePurchasableReceiptPtr PurchasableReceipt = MakeShared<FGamebasePurchasableReceipt, ESPMode::ThreadSafe>();
    PurchasableReceipt->FromJson(JsonString);
    
    return PurchasableReceipt;
}

FGamebaseEventPushMessagePtr FGamebaseEventPushMessage::From(const FString& JsonString)
{
    if (JsonString.IsEmpty() == true)
    {
        return nullptr;
    }
    
    const FGamebaseEventPushMessagePtr PushMessage = MakeShared<FGamebaseEventPushMessage, ESPMode::ThreadSafe>();
    PushMessage->FromJson(JsonString);
    
    return PushMessage;
}

void FGamebaseEventPushMessage::Serialize(FJsonSerializerBase& Serializer, bool bFlatObject)
{
    BEGIN_GAMEBASE_VO_SERIALIZER
    GAMEBASE_VO_SERIALIZE("body", Body);
    GAMEBASE_VO_SERIALIZE("extras", Extras);
    GAMEBASE_VO_SERIALIZE("id", Id);
    GAMEBASE_VO_SERIALIZE("title", Title);
    END_GAMEBASE_VO_SERIALIZER
}

FGamebaseEventPushActionPtr FGamebaseEventPushAction::From(const FString& JsonString)
{
    if (JsonString.IsEmpty() == true)
    {
        return nullptr;
    }
    
    const FGamebaseEventPushActionPtr PushAction = MakeShared<FGamebaseEventPushAction, ESPMode::ThreadSafe>();
    PushAction->FromJson(JsonString);
    
    return PushAction;
}

void FGamebaseEventPushAction::Serialize(FJsonSerializerBase& Serializer, bool bFlatObject)
{
    BEGIN_GAMEBASE_VO_SERIALIZER
    GAMEBASE_VO_SERIALIZE("actionType", ActionType);
    GAMEBASE_VO_SERIALIZE_OBJECT_SERIALIZABLE("message", Message);
    GAMEBASE_VO_SERIALIZE("userText", UserText);
    END_GAMEBASE_VO_SERIALIZER
}

FGamebaseEventLoggedOutDataPtr FGamebaseEventLoggedOutData::From(const FString& JsonString)
{
    if (JsonString.IsEmpty() == true)
    {
        return nullptr;
    }
    
    const FGamebaseEventLoggedOutDataPtr LoggedOutData = MakeShared<FGamebaseEventLoggedOutData, ESPMode::ThreadSafe>();
    LoggedOutData->FromJson(JsonString);
    
    return LoggedOutData;
}

void FGamebaseEventLoggedOutData::Serialize(FJsonSerializerBase& Serializer, bool bFlatObject)
{
    BEGIN_GAMEBASE_VO_SERIALIZER
    GAMEBASE_VO_SERIALIZE("message", message);
    GAMEBASE_VO_SERIALIZE("extras", extras);
    END_GAMEBASE_VO_SERIALIZER
}

FGamebaseEventIdPRevokedDataPtr FGamebaseEventIdPRevokedData::From(const FString& JsonString)
{
    if (JsonString.IsEmpty() == true)
    {
        return nullptr;
    }
    
    const FGamebaseEventIdPRevokedDataPtr ObserverData = MakeShared<FGamebaseEventIdPRevokedData, ESPMode::ThreadSafe>();
    ObserverData->FromJson(JsonString);
    
    return ObserverData;
}

void FGamebaseEventIdPRevokedData::Serialize(FJsonSerializerBase& Serializer, bool bFlatObject)
{
    BEGIN_GAMEBASE_VO_SERIALIZER
    GAMEBASE_VO_SERIALIZE("code", Code);
    GAMEBASE_VO_SERIALIZE("idPType", IdpType);
    GAMEBASE_VO_SERIALIZE_ARRAY("authMappingList", AuthMappingList);
    GAMEBASE_VO_SERIALIZE("extras", Extras);
    END_GAMEBASE_VO_SERIALIZER
}
