#include "GamebaseError.h"

#include "Utilities/GamebaseValueObjectSerializerMacros.h"

void FGamebaseError::AddExtra(const FString& Key, const FString& Value)
{
    if (!Extras.IsSet())
    {
        Extras.Emplace();
    }
        
    Extras.GetValue().Add(Key, Value);
}

TOptional<FString> FGamebaseError::FindExtra(const FString& Key) const
{
    if (!Extras.IsSet())
    {
        return {};
    }

    const TMap<FString, FString>& Map = Extras.GetValue();
    const FString* Found = Map.Find(Key);
    
    return Found ? TOptional<FString>(*Found) : TOptional<FString>();
}

void FGamebaseError::ForEachDepth(const FErrorVisitor& Visitor) const
{
    Visitor(*this);
    
    if (Error.IsValid())
    {
        Error->ForEachDepth(Visitor);
    }
}

int32 FGamebaseError::GetDepth() const
{
    int32 Depth = 1;
    
    if (Error.IsValid())
    {
        Depth += Error->GetDepth();
    }
    
    return Depth;
}

void FGamebaseError::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_GAMEBASE_VO_SERIALIZER
    GAMEBASE_VO_SERIALIZE("domain", Domain);
    GAMEBASE_VO_SERIALIZE("code", Code);
    GAMEBASE_VO_SERIALIZE("message", Message);
    GAMEBASE_VO_SERIALIZE_OPTIONAL("transactionId", TransactionId);
    GAMEBASE_VO_SERIALIZE_OPTIONAL_MAP("extras", Extras);
    GAMEBASE_VO_SERIALIZE_PTR_OBJECT_THREADSAFE("error", Error, FGamebaseError);
    END_GAMEBASE_VO_SERIALIZER
}