using System.IO;
using NHNCloud.Gamebase;
using UnrealBuildTool;

public class Gamebase : ModuleRules
{
    public Gamebase(ReadOnlyTargetRules Target) : base(Target)
    {
        PCHUsage = PCHUsageMode.UseExplicitOrSharedPCHs;
        
        PublicIncludePaths.AddRange(
            new[] {
                ModuleDirectory + "/Public",
                ModuleDirectory + "/Public/Constants",
                ModuleDirectory + "/Public/Interfaces",
                ModuleDirectory + "/Public/Types",
                ModuleDirectory + "/Public/Utils"
            }
        );
        
        PublicDependencyModuleNames.AddRange(
            new[]
            {
                "Core",
                "Json",
                "JsonUtilities",
            }
        );
        
        PrivateDependencyModuleNames.AddRange(
            new[]
            {
                "CoreUObject",
                "Engine",
            }
        );
        
        ExternalDependencies.Add(Path.Combine(Target.ProjectFile.Directory.FullName, "Config", "DefaultEngine.ini"));
        
        GamebaseRuntime.Initialize(this);
    }
}