#pragma once

#include "GamebaseInternalResult.h"

class UGameViewportClient;

enum class EGamebaseWebBrowserViewType
{
    Window,
    FloatingPopup,
};

struct FGamebaseWebBrowserWidgetSettings
{
    struct FNavigation
    {
        FString Title;
        FColor TitleColor = FColor::White;
        FColor IconTintColor = FColor::White;
        FColor BarColor = FColor(18, 93, 230);
        int32 BarHeight = -1;
        bool bIsForwardButton = false;
        bool bIsBackButton = true;
        bool bVisibleButtons = false;
    };

    TOptional<FNavigation> Navigation;
    FColor BackgroundColor = FColor::White;
    FVector2D ViewportSize;
    EGamebaseWebBrowserViewType ViewType = EGamebaseWebBrowserViewType::Window;
};

using FContextRequestHeaders = TMap<FString, FString>;
DECLARE_DELEGATE_FourParams(FOnBeforeContextResourceLoadDelegate, FString /*Url*/, FString /*ResourceType*/, FContextRequestHeaders& /*AdditionalHeaders*/, const bool /*AllowUserCredentials*/);
DECLARE_DELEGATE_TwoParams(FGamebaseWebBrowserError, int32 /*ErrorType*/, const FString& /*ErrorInfo*/);
DECLARE_DELEGATE_OneParam(FGamebaseWebBrowserClose, const FGamebaseErrorResult&);
DECLARE_DELEGATE_OneParam(FGamebaseWebBrowserSchemeEvent, const FString& /*RedirectURL*/);

struct FGamebaseWebBrowserContextSettings
{
    explicit FGamebaseWebBrowserContextSettings(const FString& InId)
        : Id(InId)
        , AcceptLanguageList()
        , CookieStorageLocation()
        , bPersistSessionCookies(false)
        , bIgnoreCertificateErrors(false)
        , bEnableNetSecurityExpiration(true)
    { }
    
    FString Id;
    FString AcceptLanguageList;
    FString CookieStorageLocation;
    bool bPersistSessionCookies;
    bool bIgnoreCertificateErrors;
    bool bEnableNetSecurityExpiration;
    FOnBeforeContextResourceLoadDelegate OnBeforeContextResourceLoad;
};

struct GAMEBASESTANDALONEWEBBROWSER_API FGamebaseWebBrowserParams
{
    FString Url;
    TSharedPtr<FGamebaseWebBrowserWidgetSettings> WidgetSettings;
    TSharedPtr<FGamebaseWebBrowserContextSettings> ContextSettings;
    TArray<FString> SchemeList;
    FGamebaseWebBrowserClose CloseCallback;
    FGamebaseWebBrowserSchemeEvent SchemeEventCallback;
    bool bConsumeInput = false;
    TWeakObjectPtr<UGameViewportClient> ViewportClient;
};