﻿#include "GamebaseWebBrowserUtils.h"

#include "Internationalization/Regex.h"

void GamebaseWebBrowserUtils::ParseScheme(const FString& Url, FString& OutScheme, FString& OutDomain)
{
    const static FRegexPattern RegexPattern(TEXT("^(.*?):\\/\\/(.*?)(?:\\/|$)"));
    
    FRegexMatcher RegexMatcher(RegexPattern, Url);
    if (RegexMatcher.FindNext())
    {
        OutScheme = RegexMatcher.GetCaptureGroup(1);
        OutDomain = RegexMatcher.GetCaptureGroup(2);
    }
    else {
        OutScheme = TEXT("");
        OutDomain = TEXT("");
    }
}