#pragma once

#include "CoreMinimal.h"
#include "GamebaseStandalonePurchaseAdapter.h"
#include "GamebaseStandalonePurchaseSteam.generated.h"

UCLASS()
class UGamebaseStandalonePurchaseSteam : public UGamebaseStandalonePurchaseAdapter
{
    GENERATED_BODY()

protected:
    virtual void PreInitialize(const FGamebasePurchaseConfiguration& Configuration) override;
    
    virtual FGamebaseIapConfiguration GetConfiguration(const FGamebasePurchaseConfiguration& Configuration) const override;
    virtual FIapPurchasableItemArray ConvertItemListPurchasable(const FString& JsonString) override;
    
    virtual FString GetUniqueKey() const override;
    virtual TOptional<FString> GetStoreError() const override;

private:
    TOptional<FString> ErrorMessage;
};
