﻿using NHNCloud.Gamebase;
using UnrealBuildTool;

public class GamebaseStandalonePurchaseSteam : ModuleRules
{
    public GamebaseStandalonePurchaseSteam(ReadOnlyTargetRules Target) : base(Target)
    {
        PCHUsage = PCHUsageMode.UseExplicitOrSharedPCHs;

        PrivateDependencyModuleNames.AddRange(
            new[]
            {
                "Core",
                "CoreUObject",
                "Engine",
                "Json",
                "JsonUtilities",
                "GamebaseCore",
                "GamebaseStandalone",
                "GamebaseStandalonePurchase"
            }
        );
        
        if (GamebaseRuntime.Instance.IsMacroEnabled(Macro.WITH_GAMEBASE_STEAMWORKS_SHARED))
        {
            AddEngineThirdPartyPrivateStaticDependencies(Target, "Steamworks");
        }
    }
}