#include "GamebaseStandalonePurchaseGoogle.h"

#include "Types/GamebasePurchaseConfiguration.h"
#include "Constants/GamebaseStoreCode.h"

FGamebaseIapConfiguration UGamebaseStandalonePurchaseGoogle::GetConfiguration(const FGamebasePurchaseConfiguration& Configuration) const
{
    FGamebaseIapConfiguration IapConfiguration;
    IapConfiguration.Type = GetUniqueKey();
    IapConfiguration.LibPath = TEXT("none");
    IapConfiguration.LogLevel = 2;
    IapConfiguration.LogTarget = 3;
    IapConfiguration.Appkey = Configuration.IapAppkey;
    IapConfiguration.HostUrl = Configuration.ServerUrl;
    
    return IapConfiguration;
}

FString UGamebaseStandalonePurchaseGoogle::GetUniqueKey() const
{
    return GamebaseStoreCode::Google;
}
