﻿#pragma once

#include "GamebaseInternalResult.h"
#include "GamebaseStandalonePurchaseTypes.h"
#include "Types/GamebaseError.h"

#if WITH_GAMEBASE_EOS_SHARED
#include "eos_types.h"
#endif

DECLARE_DELEGATE_OneParam(FGamebaseIapCallbackDelegate, const FGamebaseErrorPtr&);

using FGamebaseIapResult = FGamebaseInternalResult<FString>;
using FGamebaseIapResultFunc = TFunction<void(const FGamebaseIapResult&)>;

class IGamebaseIapManager : public IModularFeature
{
public:
    static IGamebaseIapManager* Get()
    {
        if (IModularFeatures::Get().IsModularFeatureAvailable(GetModularFeatureName()))
        {
            return &IModularFeatures::Get().GetModularFeature<IGamebaseIapManager>(GetModularFeatureName());
        }
        return nullptr;
    }

    static FName GetModularFeatureName()
    {
        static const FName FeatureName = TEXT("GamebaseIapManager");
        return FeatureName;
    }

public:
    virtual ~IGamebaseIapManager() = default;
    
    virtual void Initialize(const FGamebaseIapConfiguration& Configuration, const FGamebaseIapCallbackDelegate& Callback) = 0;
    virtual void SetDebugMode(bool bIsDebugMode) = 0;
    virtual void SetUserInfo(const FString& GamebaseUserId, const FString& GamebaseAccessToken) = 0;
    virtual void Login(const FGamebaseIapCallbackDelegate& Callback) = 0;
    virtual void Logout(const FGamebaseIapCallbackDelegate& Callback) = 0;
    virtual void Release() = 0;
    virtual void Update() = 0;
    virtual void AddListenerEvent() = 0;
    virtual void RemoveListenerEvent() = 0;
    
    virtual void RequestReprocessPurchased(const FString& GamebaseItemListJsonString, const FGamebaseIapCallbackDelegate& Callback) = 0;
    virtual void RequestItemListOfNotConsumed(bool bAllStores, FGamebaseIapResultFunc&& Callback) = 0;
    virtual void RequestItemListPurchasable(FGamebaseIapResultFunc&& Callback) = 0;
    virtual void RequestPurchaseProductId(const FString& MarketItemId, const FString& GamebaseItemId, FGamebaseIapResultFunc&& Callback) = 0;
    virtual void RequestPurchaseProductIdWithPayload(const FString& MarketItemId, const FString& GamebaseItemId, const FString& Payload, FGamebaseIapResultFunc&& Callback) = 0;

#if WITH_GAMEBASE_EOS_SHARED
    virtual void SetEOSPlatformHandle(EOS_HPlatform PlatformHandle) = 0;
#endif
};
