#pragma once

#include "GamebaseAdapterBase.h"
#include "GamebaseStandalonePurchaseTypes.h"
#include "GamebaseTicker.h"
#include "GamebaseStandalonePurchaseAdapter.generated.h"

struct FGamebasePurchaseConfiguration;
struct FGamebasePurchasableConfiguration;
class IGamebaseIapManager;

UCLASS(Abstract)
class GAMEBASESTANDALONEPURCHASE_API UGamebaseStandalonePurchaseAdapter : public UGamebaseAdapterBase
{
    GENERATED_BODY()
    
public:
    using FIapResultFunc = TFunction<void(const FGamebaseError*)>;
    
    void Initialize(const FGamebasePurchaseConfiguration& Configuration, FIapResultFunc&& Callback);
    void SetDebugMode(bool bIsDebugMode);
    void SetGamebaseUserId(const FString& GamebaseUserId, const FString& GamebaseToken);
    void SetDisplayLanguage(const FString& LanguageCode);
    void RequestReprocessPurchased(const FString& GamebaseItemListJsonString, const FIapResultFunc& Callback);
    void RequestPurchase(const FString& MarketItemId, const FString& GamebaseProductId, const FIapPurchaseReceiptDelegate& Callback);
    void RequestPurchase(const FString& MarketItemId, const FString& GamebaseProductId, const FString& Payload, const FIapPurchaseReceiptDelegate& Callback);
    void RequestItemListPurchasable(const FIapPurchasableItemListDelegate& Callback);
    void RequestItemListAtIAPConsole(const FIapPurchasableItemListDelegate& Callback);
    void RequestItemListOfNotConsumed(const FGamebasePurchasableConfiguration& Configuration, const FIapPurchaseReceiptListDelegate& Callback);

protected:
    virtual void PreInitialize(const FGamebasePurchaseConfiguration& Configuration);
    virtual FIapPurchasableItemArray ConvertItemListPurchasable(const FString& JsonString);
    
    virtual FGamebaseIapConfiguration GetConfiguration(const FGamebasePurchaseConfiguration& Configuration) const
        PURE_VIRTUAL(UGamebaseStandalonePurchaseAdapter::GetConfiguration, return {};);

    virtual TOptional<FString> GetStoreError() const;
    FString GetDisplayLanguage() const;

    IGamebaseIapManager* GetIapManager() const;

private:
    bool Tick(float DeltaTime);
    
private:
    FGamebaseTickerDelegateHandle TickDelegateHandle;
    IGamebaseIapManager* IapManager;
    FString SavedDisplayLanguage;
};