#pragma once

#include "GamebaseJsonSerializerMacros.h"

namespace GpWindowsIapSdk
{
    struct FConfiguration final : FGamebaseJsonSerializable
    {
        struct FIdpInfo final : FGamebaseJsonSerializable
        {
            FString ApplicationId;
            FString ProductId;
            FString SandboxId;
            FString DeploymentId;
            FString ClientCredentialsId;
            FString ClientCredentialsSecret;
            FString GameName;
            FString GameOfferId;
            
            BEGIN_GAMEBASE_JSON_SERIALIZER
                GAMEBASE_JSON_SERIALIZE_STRING("ApplicationId", ApplicationId);
                GAMEBASE_JSON_SERIALIZE_STRING("ProductId", ProductId);
                GAMEBASE_JSON_SERIALIZE_STRING("SandboxId", SandboxId);
                GAMEBASE_JSON_SERIALIZE_STRING("DeploymentId", DeploymentId);
                GAMEBASE_JSON_SERIALIZE_STRING("ClientCredentialsId", ClientCredentialsId);
                GAMEBASE_JSON_SERIALIZE_STRING("ClientCredentialsSecret", ClientCredentialsSecret);
                GAMEBASE_JSON_SERIALIZE_STRING("gameName", GameName);
                GAMEBASE_JSON_SERIALIZE_STRING("gameOfferId", GameOfferId);
            END_GAMEBASE_JSON_SERIALIZER
        };
        
        FString Type;
        int32 LogLevel;
        int32 LogTarget;
        FString HostUrl;
        FString Appkey;
        FIdpInfo IdpInfo;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE_STRING("type", Type);
            GAMEBASE_JSON_SERIALIZE("logLevel", LogLevel);
            GAMEBASE_JSON_SERIALIZE("logTarget", LogTarget);
            GAMEBASE_JSON_SERIALIZE_STRING("hostUrl", HostUrl);
            GAMEBASE_JSON_SERIALIZE_STRING("appKey", Appkey);
            GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("idpInfo", IdpInfo);
        END_GAMEBASE_JSON_SERIALIZER
    };
    
    struct FPurchasableDefaultData final : FGamebaseJsonSerializable
    {
        int32 ProductNo;
        FString ProductId;
        float OriginalPrice;
        FString Currency;
        bool bPriceValid;
        FString ProductName;
        FString LocalizedPrice;
        FString LocalizedDescription;
        int32 DecimalPoint;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE("marketProductId", ProductId);
            GAMEBASE_JSON_SERIALIZE("productNo", ProductNo);
            GAMEBASE_JSON_SERIALIZE("originalPrice", OriginalPrice);
            GAMEBASE_JSON_SERIALIZE("currency", Currency);
            GAMEBASE_JSON_SERIALIZE("decimalPoint", DecimalPoint);
            GAMEBASE_JSON_SERIALIZE("priceValid", bPriceValid);
            GAMEBASE_JSON_SERIALIZE("productName", ProductName);
            GAMEBASE_JSON_SERIALIZE("localizedPrice", LocalizedPrice);
            GAMEBASE_JSON_SERIALIZE("localizedDescription", LocalizedDescription);
        END_GAMEBASE_JSON_SERIALIZER
    };
    
    struct FPurchaseReceiptData final : FGamebaseJsonSerializable
    {
        FString Currency;
        FString GamebaseProductId;
        FString MarketItemId;
        FString OriginalPaymentId;
        FString PaymentId;
        FString PaymentSeq;
        float Price;
        FString ProductType;
        int64 PurchaseTime;
        FString PurchaseToken;
        FString UserId;
        FString GamebasePayload;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE("currency", Currency);
            GAMEBASE_JSON_SERIALIZE("gamebaseProductId", GamebaseProductId);
            GAMEBASE_JSON_SERIALIZE("marketItemId", MarketItemId);
            GAMEBASE_JSON_SERIALIZE("originalPaymentId", OriginalPaymentId);
            GAMEBASE_JSON_SERIALIZE("paymentId", PaymentId);
            GAMEBASE_JSON_SERIALIZE("paymentSeq", PaymentSeq);
            GAMEBASE_JSON_SERIALIZE("price", Price);
            GAMEBASE_JSON_SERIALIZE("productType", ProductType);
            GAMEBASE_JSON_SERIALIZE("purchaseTime", PurchaseTime);
            GAMEBASE_JSON_SERIALIZE("purchaseToken", PurchaseToken);
            GAMEBASE_JSON_SERIALIZE("userId", UserId);
            GAMEBASE_JSON_SERIALIZE("gamebasePayload", GamebasePayload);
        END_GAMEBASE_JSON_SERIALIZER
    };
    
    struct FGamebasePayload final : FGamebaseJsonSerializable
    {
        FString StoreUserId;
        FString GamebaseProductId;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE("storeUserId", StoreUserId);
            GAMEBASE_JSON_SERIALIZE("gamebaseProductId", GamebaseProductId);
        END_GAMEBASE_JSON_SERIALIZER
    };
}
