﻿#include "IGamebaseIapManager.h"
#include "Modules/ModuleManager.h"

#if WITH_GP_IAP_SDK
#include "Windows/GamebasePlatformDefines.h"
#endif

class FGamebaseStandalonePurchaseModule final : public IModuleInterface
{
public:
    virtual void StartupModule() override;
    virtual void ShutdownModule() override;
    
#if WITH_GP_IAP_SDK
    TUniquePtr<FPlatformGpIapManager> SDKManager;
#endif
};

void FGamebaseStandalonePurchaseModule::StartupModule()
{
#if WITH_GP_IAP_SDK
    SDKManager = MakeUnique<FPlatformGpIapManager>();
    check(SDKManager);

    IModularFeatures::Get().RegisterModularFeature(IGamebaseIapManager::GetModularFeatureName(), SDKManager.Get());
#endif
}

void FGamebaseStandalonePurchaseModule::ShutdownModule()
{
#if WITH_GP_IAP_SDK
    if (SDKManager.IsValid())
    {
        IModularFeatures::Get().UnregisterModularFeature(IGamebaseIapManager::GetModularFeatureName(), SDKManager.Get());
        SDKManager->Shutdown();
        SDKManager.Reset();
    }
#endif
}

IMPLEMENT_MODULE(FGamebaseStandalonePurchaseModule, GamebaseStandalonePurchase)
