﻿using NHNCloud.Gamebase;
using UnrealBuildTool;

public class GamebaseStandalonePurchase : ModuleRules
{
    public GamebaseStandalonePurchase(ReadOnlyTargetRules Target) : base(Target)
    {
        PCHUsage = PCHUsageMode.UseExplicitOrSharedPCHs;
        
        PublicDependencyModuleNames.AddRange(
            new[]
            {
                "Core",
                "Gamebase",
                "GamebaseCore",
            }
        );

        PrivateDependencyModuleNames.AddRange(
            new[]
            {
                "CoreUObject",
                "Engine",
                "Json",
                "JsonUtilities",
                "GPIAP",
                "GamebaseCommon"
            }
        );

        PublicSystemLibraries.Add("crypt32.lib");
        
        if (GamebaseRuntime.Instance.IsMacroEnabled(Macro.WITH_GAMEBASE_EOS_SHARED))
        {
            PublicDependencyModuleNames.Add("EOSSDK");
        }
    }
}