#include "GamebaseStandaloneAuthGoogle.h"

#include "GamebaseAuthProvider.h"
#include "GamebaseStandaloneAuthProviderCredential.h"

namespace GamebaseAuthGoogle
{
    const TArray<FString> StoreScopes = {
        TEXT("profile"),
        TEXT("https://www.googleapis.com/auth/googleplay.products"),
        TEXT("https://www.googleapis.com/auth/googleplay.purchases")
    };
    
    const FString StoreScope = FString::Join(StoreScopes, TEXT(" "));
    
    const FName StoreAccessType("offline");
}

FGamebaseVariantMap UGamebaseStandaloneAuthGoogle::GetProviderSpecificQueries() const
{
    FGamebaseVariantMap Result = {
        { GamebaseAuthMemberWebLoginParameter::SnsCd, GetUniqueKey() }
    };

    if (AuthConfiguration.UserAdditionalInfo.Contains(GamebaseAuthProviderCredential::Store))
    {
        Result.Emplace(GamebaseAuthMemberWebLoginParameter::Scope, GamebaseAuthGoogle::StoreScope);
        Result.Emplace(GamebaseAuthMemberWebLoginParameter::AccessType, GamebaseAuthGoogle::StoreAccessType);
    }
    
    return Result;
}

FGamebaseVariantMap UGamebaseStandaloneAuthGoogle::GetProviderSpecificCredential() const
{
    return {};
}

FString UGamebaseStandaloneAuthGoogle::GetUniqueKey() const
{
    return GamebaseAuthProvider::Google;
}

EGamebaseStandaloneAuthMemberWebType UGamebaseStandaloneAuthGoogle::GetViewType() const
{
    return EGamebaseStandaloneAuthMemberWebType::ExternalBrowser;
}