#include "GamebaseStandaloneAuthAppleId.h"

#include "GamebaseAuthProvider.h"
#include "GamebaseAuthProviderCredential.h"

namespace GamebaseAuthAppleIdConstants
{
    const FName SubCode("sign_in_with_apple_js");
}

FGamebaseVariantMap UGamebaseStandaloneAuthAppleId::GetProviderSpecificQueries() const
{
    return
    {
        { GamebaseAuthMemberWebLoginParameter::SocialNetworkingServiceSubCode, GamebaseAuthAppleIdConstants::SubCode }
    };
}

FGamebaseVariantMap UGamebaseStandaloneAuthAppleId::GetProviderSpecificCredential() const
{
    return
    {
        { GamebaseAuthProviderCredential::SubCode, GamebaseAuthAppleIdConstants::SubCode.ToString() }
    };
}

FString UGamebaseStandaloneAuthAppleId::GetUniqueKey() const
{
    return GamebaseAuthProvider::AppleId;
}
