#pragma once

#include "CoreMinimal.h"
#include "../IGamebaseEOSInitializer.h"

class FGamebaseEOSOSSInitializer final
    : public IGamebaseEOSInitializer
{
public:
    FGamebaseEOSOSSInitializer() = default;
    virtual ~FGamebaseEOSOSSInitializer() override = default;

    virtual bool IsAvailable() const override;
    virtual void Initialize(UGameInstance* GameInstance) override;
    virtual void Deinitialize() override;
    virtual void SetPlatformHandle(FEOSPlatformHandle PlatformHandle) override;
    virtual FEOSPlatformHandle GetPlatformHandle() const override;

private:
#if WITH_GAMEBASE_EOS_OSS
    void InitializeEOSOnlineSubsystem(UGameInstance* GameInstance);
    bool SetupEOSPlatformHandleFromOSS(UGameInstance* GameInstance);
#endif

private:
#if WITH_GAMEBASE_EOS_SHARED
    FEOSPlatformHandle EOSPlatformHandle = nullptr;
#endif
};
