#include "GamebaseEOSOSSInitializer.h"
#include "GamebaseDebugLogger.h"
#include "Engine/GameInstance.h"

#define IS_EOS_OLD_SYSTEM (ENGINE_MAJOR_VERSION == 4 && ENGINE_MINOR_VERSION >= 27) || (ENGINE_MAJOR_VERSION == 5 && ENGINE_MINOR_VERSION == 0)

#if WITH_GAMEBASE_EOS_OSS
#include "OnlineSubsystem.h"
#include "OnlineSubsystemUtils.h"

#if IS_EOS_OLD_SYSTEM
#include "OnlineSubsystemEOS.h"
#include "IEOSSDKManager.h"
#else
#include "IOnlineSubsystemEOS.h"
#include "IEOSSDKManager.h"
#endif
#endif

bool FGamebaseEOSOSSInitializer::IsAvailable() const
{
#if WITH_GAMEBASE_EOS_OSS
    return true;
#else
    return false;
#endif
}

void FGamebaseEOSOSSInitializer::Initialize(UGameInstance* GameInstance)
{
    if (!GameInstance)
    {
        GAMEBASE_LOG_GLOBAL_ERROR("GameInstance is null");
        return;
    }

#if WITH_GAMEBASE_EOS_OSS
    InitializeEOSOnlineSubsystem(GameInstance);
#endif
}

void FGamebaseEOSOSSInitializer::Deinitialize()
{
#if WITH_GAMEBASE_EOS_SHARED
    EOSPlatformHandle = nullptr;
#endif
    GAMEBASE_LOG_GLOBAL_DEBUG("EOS OnlineSubsystem initializer deinitialized");
}

void FGamebaseEOSOSSInitializer::SetPlatformHandle(const FEOSPlatformHandle PlatformHandle)
{
    GAMEBASE_LOG_GLOBAL_WARNING("SetPlatformHandle is blocked when using EOS OnlineSubsystem. Platform handle is managed automatically.");
}

FEOSPlatformHandle FGamebaseEOSOSSInitializer::GetPlatformHandle() const
{
#if WITH_GAMEBASE_EOS_SHARED
    return EOSPlatformHandle;
#else
    return nullptr;
#endif
}

#if WITH_GAMEBASE_EOS_OSS
void FGamebaseEOSOSSInitializer::InitializeEOSOnlineSubsystem(UGameInstance* GameInstance)
{
    IOnlineSubsystem* Subsystem = Online::GetSubsystem(GameInstance->GetWorld(), EOS_SUBSYSTEM);
    if (!Subsystem)
    {
        GAMEBASE_LOG_GLOBAL_WARNING("EOS OnlineSubsystem is null");
        return;
    }

    if (SetupEOSPlatformHandleFromOSS(GameInstance))
    {
        GAMEBASE_LOG_GLOBAL_DEBUG("EOS OnlineSubsystem initializer initialized successfully");
    }
    else
    {
        GAMEBASE_LOG_GLOBAL_WARNING("Failed to setup EOS Platform Handle from OnlineSubsystem");
    }
}

bool FGamebaseEOSOSSInitializer::SetupEOSPlatformHandleFromOSS(UGameInstance* GameInstance)
{
    IOnlineSubsystem* Subsystem = Online::GetSubsystem(GameInstance->GetWorld(), EOS_SUBSYSTEM);
    if (!Subsystem)
    {
        return false;
    }

#if IS_EOS_OLD_SYSTEM
    const FOnlineSubsystemEOS* EosSubsystem = static_cast<FOnlineSubsystemEOS*>(Subsystem);
    if (!EosSubsystem)
    {
        return false;
    }

#if WITH_GAMEBASE_EOS_SHARED
    EOSPlatformHandle = *EosSubsystem->EOSPlatformHandle;
#endif
    return true;

#else
    const IOnlineSubsystemEOS* EosSubsystem = static_cast<IOnlineSubsystemEOS*>(Subsystem);
    if (!EosSubsystem)
    {
        return false;
    }

#if WITH_GAMEBASE_EOS_SHARED
    EOSPlatformHandle = *EosSubsystem->GetEOSPlatformHandle();
#endif
    return true;
#endif
}
#endif
