#pragma once

#include "CoreMinimal.h"
#include "GamebaseSharedEOS.h"

class IGamebaseEOSInitializer
{
public:
    virtual ~IGamebaseEOSInitializer() = default;

    virtual bool IsAvailable() const = 0;

    virtual void Initialize(UGameInstance* GameInstance) = 0;
    virtual void Deinitialize() = 0;
    
    virtual void SetPlatformHandle(FEOSPlatformHandle PlatformHandle) = 0;
    virtual FEOSPlatformHandle GetPlatformHandle() const = 0;
};
