#pragma once

#if WITH_GAMEBASE_EOS_OSS

#include "Auth/GamebaseEOSAuthHandler.h"
#include "Interfaces/OnlineIdentityInterface.h"

class FGamebaseOnlineSubsystemAuthHandler final
    : public FGamebaseEOSAuthHandler
{
public:
    explicit FGamebaseOnlineSubsystemAuthHandler(const TWeakObjectPtr<UGameInstance>& GameInstance);

protected:
    virtual FLoginAsyncFunc AsyncLoginWithExistingSession() override;
    virtual FLoginAsyncFunc AsyncLoginWithExchangeCode() override;
    virtual FLoginAsyncFunc AsyncLoginWithPersistentAuth() override;
    virtual FLoginAsyncFunc AsyncLoginWithAccountPortal() override;

    virtual FLogoutAsyncFunc AsyncLogout() override;

private:
    static FLoginResultFuture LoginWithCredentialsAsync(const FOnlineAccountCredentials& Credentials);
    
private:
    TWeakObjectPtr<UGameInstance> GameInstance;
};

#endif // WITH_GAMEBASE_EOS_OSS