#pragma once

#if WITH_GAMEBASE_EOS_NATIVE_SDK

#include "eos_auth_types.h"
#include "Auth/GamebaseEOSAuthHandler.h"

class FGamebaseEOSSDKAuthHandler final
    : public FGamebaseEOSAuthHandler
{
public:
    explicit FGamebaseEOSSDKAuthHandler(const TWeakObjectPtr<UGameInstance>& GameInstance)
        : GameInstance(GameInstance)
        , EpicAccountId(nullptr)
    {
    }

    virtual ~FGamebaseEOSSDKAuthHandler() override = default;

protected:
    virtual FLoginAsyncFunc AsyncLoginWithExistingSession() override;
    virtual FLoginAsyncFunc AsyncLoginWithExchangeCode() override;
    virtual FLoginAsyncFunc AsyncLoginWithPersistentAuth() override;
    virtual FLoginAsyncFunc AsyncLoginWithAccountPortal() override;

    virtual FLogoutAsyncFunc AsyncLogout() override;
    
private:
    FLoginResultFuture LoginWithCredentialsAsync(const EOS_Auth_LoginOptions& LoginOptions);

private:
    TWeakObjectPtr<UGameInstance> GameInstance;
    
    EOS_EpicAccountId EpicAccountId;
};

#endif // WITH_GAMEBASE_EOS_NATIVE_SDK