﻿using NHNCloud.Gamebase;
using UnrealBuildTool;

public class GamebaseSharedEOS : ModuleRules
{
    public GamebaseSharedEOS(ReadOnlyTargetRules Target) : base(Target)
    {
        PCHUsage = PCHUsageMode.UseExplicitOrSharedPCHs;

        PublicDependencyModuleNames.AddRange(
            new[]
            {
                "Core",
                "Gamebase",
            }
        );
        
        PrivateDependencyModuleNames.AddRange(
            new[]
            {
                "Core",
                "CoreUObject",
                "Engine",
                "Json",
                "JsonUtilities",
                "GamebaseCore"
            }
        );

        if (GamebaseRuntime.Instance.IsMacroEnabled(Macro.WITH_GAMEBASE_EOS_SHARED))
        {   
            PublicDependencyModuleNames.Add("EOSSDK");
        }

        if (GamebaseRuntime.Instance.IsMacroEnabled(Macro.WITH_GAMEBASE_EOS_OSS))
        {   
            PrivateDependencyModuleNames.AddRange(
                new[]
                {
                    "OnlineSubsystem",
                    "OnlineSubsystemUtils",
                    "OnlineSubsystemEOS",
                    "EOSShared",
                });
        }
    }
}