#pragma once

#include "CoreMinimal.h"
#include "GamebaseBridgeAuthAdapter.h"
#include "GamebaseBridgeAuthEpicGames.generated.h"

UCLASS()
class UGamebaseBridgeAuthEpicGames final
    : public UGamebaseBridgeAuthAdapter
{
    GENERATED_BODY()

public:
    virtual void Initialize() override;
    virtual void Login(const FLoginCallback& Callback) override;
    virtual void Login(const FGamebaseVariantMap& AdditionalInfo, const FLoginCallback& Callback) override;
    virtual void Logout(const FLogoutCallback& Callback) override;
    virtual void Withdraw(const FWithdrawCallback& Callback) override;
    virtual FString GetProviderName() const override;
    virtual FString GetUserID() const override;
    virtual FString GetAccessToken() const override;
    virtual FGamebaseAuthProviderProfilePtr GetProfile() const override;
    
protected:
    virtual FString GetUniqueKey() const override;

private:
    UPROPERTY(transient)
    UGameInstance* GameInstance;
};
