#include "GamebaseBridgeAuthEpicGames.h"

#include "GamebaseAuthProvider.h"
#include "GamebaseAuthProviderCredential.h"
#include "GamebaseDebugLogger.h"
#include "GamebaseSharedEOS.h"
#include "GamebaseErrorCode.h"
#include "IGamebaseEOSAuthHandler.h"

namespace GamebaseStandaloneAuthEpic
{
    const FName Domain { TEXT("GamebaseStandaloneAuthEpic") };
    const FName AuthorizationProtocol { TEXT("epicgames") };
}

void UGamebaseBridgeAuthEpicGames::Initialize()
{
    GameInstance = GetWorld()->GetGameInstance();
    GAMEBASE_LOG_GLOBAL_DEBUG("UGamebaseBridgeAuthEpic::Initialize");
}

void UGamebaseBridgeAuthEpicGames::Login(
    const FLoginCallback& Callback)
{
    if (const auto AuthHandler = UGameInstance::GetSubsystem<UGamebaseSharedEOS>(GameInstance)->GetAuthHandler())
    {
        AuthHandler->Login([Callback](const FGamebaseAuthEpicLoginResult& Result)
        {
            if (Result.IsError())
            {
                Callback(FGamebaseAuthCredentialsResult(Result.GetErrorValue()));
                return;
            }
        
            FGamebaseAuthCredentials Credentials;
            Credentials.Add(GamebaseAuthProviderCredential::ProviderName, GamebaseAuthProvider::EpicGames);
            Credentials.Add(GamebaseAuthProviderCredential::AccessToken, Result.GetOkValue().AccessToken);

            Callback(FGamebaseAuthCredentialsResult(Credentials));
        });
    }
    else
    {
        Callback(FGamebaseAuthCredentialsResult(
            FGamebaseError(
                GamebaseErrorCode::AUTH_IDP_LOGIN_FAILED,
                TEXT("AuthHandler is not available"),
                GamebaseStandaloneAuthEpic::Domain
            )
        ));
    }
}

void UGamebaseBridgeAuthEpicGames::Login(
    const FGamebaseVariantMap& AdditionalInfo,
    const FLoginCallback& Callback)
{
    if (const auto AuthHandler = UGameInstance::GetSubsystem<UGamebaseSharedEOS>(GameInstance)->GetAuthHandler())
    {
        AuthHandler->Login([Callback](const FGamebaseAuthEpicLoginResult& Result)
        {
            if (Result.IsError())
            {
                Callback(FGamebaseAuthCredentialsResult(Result.GetErrorValue()));
                return;
            }

            FGamebaseAuthCredentials Credentials;
            Credentials.Add(GamebaseAuthProviderCredential::ProviderName, GamebaseAuthProvider::EpicGames);
            Credentials.Add(GamebaseAuthProviderCredential::AccessToken, Result.GetOkValue().AccessToken);

            Callback(FGamebaseAuthCredentialsResult(Credentials));
        });
    }
    else
    {
        Callback(FGamebaseAuthCredentialsResult(
            FGamebaseError(
                GamebaseErrorCode::AUTH_IDP_LOGIN_FAILED,
                TEXT("AuthHandler is not available"),
                GamebaseStandaloneAuthEpic::Domain
            )
        ));
    }
}

void UGamebaseBridgeAuthEpicGames::Logout(
    const FLogoutCallback& Callback)
{
    if (const auto AuthHandler = UGameInstance::GetSubsystem<UGamebaseSharedEOS>(GameInstance)->GetAuthHandler())
    {
        AuthHandler->Logout();
    }

    Callback();
}

void UGamebaseBridgeAuthEpicGames::Withdraw(
    const FWithdrawCallback& Callback)
{
    if (const auto AuthHandler = UGameInstance::GetSubsystem<UGamebaseSharedEOS>(GameInstance)->GetAuthHandler())
    {
        AuthHandler->Logout();
    }

    Callback();
}

FString UGamebaseBridgeAuthEpicGames::GetProviderName() const
{
    return Super::GetProviderName();
}

FString UGamebaseBridgeAuthEpicGames::GetUserID() const
{
    return Super::GetUserID();
}

FString UGamebaseBridgeAuthEpicGames::GetAccessToken() const
{
    return Super::GetAccessToken();
}

FGamebaseAuthProviderProfilePtr UGamebaseBridgeAuthEpicGames::GetProfile() const
{
    return Super::GetProfile();
}

FString UGamebaseBridgeAuthEpicGames::GetUniqueKey() const
{
    return GamebaseAuthProvider::EpicGames;
}
