﻿#pragma once

#include "GpLoggerConfiguration.h"

struct FGpLoggerSettings;

enum class EGpLoggerSettingResult
{
    Success,
    Failed
};

class IGpLoggerSettingLoader : public TSharedFromThis<IGpLoggerSettingLoader>
{
public:
    using FUpdateCompleteFunc = TFunction<void (const FGpLoggerSettings& Settings)>;
    
public:
    IGpLoggerSettingLoader(const FString& Appkey, const EGpLoggerServiceZone ServiceZone)
        : Appkey(Appkey)
        , ServiceZone(ServiceZone)
    {
    }
    virtual ~IGpLoggerSettingLoader() = default;

    virtual void Update(FUpdateCompleteFunc&& Func) = 0;

protected:
    const FString Appkey;
    const EGpLoggerServiceZone ServiceZone;
};

class FGpLoggerDefaultSettingLoader final : public IGpLoggerSettingLoader
{
public:
    FGpLoggerDefaultSettingLoader(const FString& Appkey, const EGpLoggerServiceZone ServiceZone)
        : IGpLoggerSettingLoader(Appkey, ServiceZone)
    {
    }

    virtual void Update(FUpdateCompleteFunc&& Func) override;
};

using FGpLoggerSettingResult = struct{ EGpLoggerSettingResult Result; FString Message; };

class FGpLoggerConsoleSettingLoader final : public IGpLoggerSettingLoader
{
public:
    FGpLoggerConsoleSettingLoader(const FString& Appkey, const EGpLoggerServiceZone ServiceZone)
        : IGpLoggerSettingLoader(Appkey, ServiceZone)
    {
    }

    virtual void Update(FUpdateCompleteFunc&& Func) override;

private:
    TFuture<FGpLoggerSettingResult> Request();
};