﻿#pragma once

#include "CoreMinimal.h"
#include "GpLoggerLogInfo.h"

using FGpTransferErrorMessage = FString;

struct FGpLoggerTransferResult
{
    FGpLoggerServiceData ServiceData;
    TArray<FGpLoggerLogData> SuccessLogs;
    TArray<FGpLoggerLogData> FailedLogs;
    TArray<FGpTransferErrorMessage> FailedLogErrors;
    FGpBulkLogDataPtr BulkData;
    FString ErrorMessage;
};

class FGpLoggerLogTransfer final
    : public FRunnable
    , public TSharedFromThis<FGpLoggerLogTransfer>
{
    using FTransferQueue = TQueue<FGpBulkLogDataPtr, EQueueMode::Mpsc>;
    
public:
    explicit FGpLoggerLogTransfer();
    virtual ~FGpLoggerLogTransfer() override;

    void Enqueue(const FGpBulkLogDataRef& BulkLog);
    void DirectTransfer();
    
    DECLARE_DELEGATE_OneParam(FOnTransferDelegate, const FGpLoggerTransferResult&);
    FOnTransferDelegate& GetTransferDelegate() { return OnTransferDelegate; }
    
    //~ FRunnable interface
    virtual bool Init() override;
    virtual uint32 Run() override;
    virtual void Stop() override;
    virtual void Exit() override;

    FORCEINLINE bool ShouldStop() const
    {
        return StopTaskCounter.GetValue() > 0;
    }

private:
    void ProcessTransfer();
    void ProcessTransferBulk(const FGpBulkLogDataRef& BulkLogData);

private:
    TUniquePtr<FRunnableThread> RunnableThread;
    FThreadSafeCounter StopTaskCounter;
    
    mutable FCriticalSection DataGuard;
    FTransferQueue SendQueue;
    
    FOnTransferDelegate OnTransferDelegate;
};
