﻿#pragma once

#include "CoreMinimal.h"
#include "GpLoggerLogInfo.h"
#include "GpLoggerSaveData.h"

class FGpLoggerBackupStorage
{
public:
    FGpBulkLogDataPtr LoadData(const FGpLoggerServiceData& ServiceData);
    bool SaveData(const FGpLoggerServiceData& ServiceData, const FGpLoggerBulkLogData& Info);
    bool DeleteData(const FGpLoggerServiceData& ServiceData, const FGpLoggerBulkLogData& Info);
    
    void DeleteOldData(const FGpLoggerServiceData& ServiceData);

private:
    TMap<FString, UGpLoggerLogSave*> BackupLogs;
};
