#pragma once

#include "Serialization/JsonSerializerMacros.h"

#define BEGIN_GPLOGGER_JSON_SERIALIZER                                                  BEGIN_JSON_SERIALIZER
#define END_GPLOGGER_JSON_SERIALIZER                                                    END_JSON_SERIALIZER
#define GPLOGGER_JSON_SERIALIZE(JsonName, JsonValue)                                    JSON_SERIALIZE(JsonName, JsonValue)
#define GPLOGGER_JSON_SERIALIZE_ARRAY(JsonName, JsonArray)                              JSON_SERIALIZE_ARRAY(JsonName, JsonArray) 
#define GPLOGGER_JSON_SERIALIZE_MAP(JsonName, JsonMap)                                  JSON_SERIALIZE_MAP(JsonName, JsonMap)
#define GPLOGGER_JSON_SERIALIZE_SIMPLE_COPY(JsonMap)                                    JSON_SERIALIZE_SIMPLECOPY(JsonMap)
#define GPLOGGER_JSON_SERIALIZE_SERIALIZABLE(JsonName, JsonValue)                       JSON_SERIALIZE_SERIALIZABLE(JsonName, JsonValue) 
#define GPLOGGER_JSON_SERIALIZE_RAW_JSON_STRING(JsonName, JsonValue)                    JSON_SERIALIZE_RAW_JSON_STRING(JsonName, JsonValue)
#define GPLOGGER_JSON_SERIALIZE_ARRAY_SERIALIZABLE(JsonName, JsonArray, ElementType)    JSON_SERIALIZE_ARRAY_SERIALIZABLE(JsonName, JsonArray, ElementType)
#define GPLOGGER_JSON_SERIALIZE_MAP_SERIALIZABLE(JsonName, JsonMap, ElementType)        JSON_SERIALIZE_MAP_SERIALIZABLE(JsonName, JsonMap, ElementType) 
#define GPLOGGER_JSON_SERIALIZE_OBJECT_SERIALIZABLE(JsonName, JsonSerializableObject)   JSON_SERIALIZE_OBJECT_SERIALIZABLE(JsonName, JsonSerializableObject) 
#define GPLOGGER_JSON_SERIALIZE_DATETIME_UNIX_TIMESTAMP(JsonName, JsonDateTime)         JSON_SERIALIZE_DATETIME_UNIX_TIMESTAMP(JsonName, JsonDateTime)

#define GPLOGGER_JSON_SERIALIZE_OBJECT_STRING_SERIALIZABLE(JsonName, JsonValue) \
    FString JsonTextValue = JsonValue.ToJson(false); \
    Serializer.Serialize(TEXT(JsonName), JsonTextValue)

#define GPLOGGER_JSON_SERIALIZE_STRING(JsonName, JsonValue) \
    if (!JsonValue.IsEmpty()) \
    { \
        Serializer.Serialize(TEXT(JsonName), JsonValue); \
    } \

typedef FJsonSerializable FGpLoggerJsonSerializable;
typedef FJsonSerializerWriter<> FGpLoggerJsonSerializerWriter;
