﻿#pragma once

#include "CoreMinimal.h"
#include "GpLoggerSubsystem.h"
#include "GpLoggerCoreSubsystem.generated.h"

class UGpInternalInstanceLogger;
class UGpBaseLogger;
class UGpLoggerInstance;
struct FGpLoggerCrashInternalData;

UCLASS(Abstract)
class GPLOGGERCORE_API UGpLoggerCoreSubsystem : public UGpLoggerSubsystem
{
    GENERATED_BODY()

public:
    virtual void Initialize(const FGpLoggerConfiguration& Configuration) override final;
    
    virtual void Debug(const FString& Message, const TMap<FString, FString>& UserFields) override final;
    virtual void Info(const FString& Message, const TMap<FString, FString>& UserFields) override final;
    virtual void Warn(const FString& Message, const TMap<FString, FString>& UserFields) override final;
    virtual void Error(const FString& Message, const TMap<FString, FString>& UserFields) override final;
    virtual void Fatal(const FString& Message, const TMap<FString, FString>& UserFields) override final;
    
    virtual void SetUserField(const FString& Key, const FString& Value) override final;
    virtual void SetLoggerListener(const FGpLoggerEventListener& Listener) override final;
    virtual void SetCrashListener(const FGpLoggerCrashListener& Listener) override final;
    
    virtual void SetGameUserId(const FString& UserId) override final;
    
    virtual UGpLoggerInstance* NewInstance(const FString& Appkey, EGpLoggerServiceZone ServiceZone) override final;
    
    static UGpLoggerCoreSubsystem* GetSubsystem(const FString& InstanceName);
    static int32 GetSubsystemCount();
    
protected:
    void OnCrashed(const FGpLoggerCrashInternalData& CrashData);
    bool IsCrashFilter(const FGpLoggerCrashInternalData& CrashData);
    
    virtual UClass* GetLoggerClass() const PURE_VIRTUAL(UGpLoggerCoreSubsystem::GetLoggerClass, return nullptr;);
    virtual UClass* GetInstanceLoggerClass() const PURE_VIRTUAL(UGpLoggerCoreSubsystem::GetInstanceLoggerClass, return nullptr;);
    
    // USubsystem interface
    virtual void Initialize(FSubsystemCollectionBase& Collection) override;
    virtual void Deinitialize() override;
    // ~USubsystem interface

private:
    UPROPERTY()
    UGpBaseLogger* Logger;
    
    FGpLoggerCrashFilterDelegate IsCrashFilterDelegate;
    
    TArray<TWeakObjectPtr<UGpInternalInstanceLogger>> InstanceLoggers;
    FDelegateHandle CrashDelegateHandle;
    
    static TMap<FString, TWeakObjectPtr<UGpLoggerCoreSubsystem>> SubsystemMap;
};