﻿#pragma once

#include "CoreMinimal.h"
#include "GpLoggerConfiguration.h"
#include "GpLoggerInstance.h"
#include "GpInternalInstanceLogger.generated.h"

class UGpBaseLogger;

UCLASS()
class UGpInternalInstanceLogger : public UGpLoggerInstance
{
    GENERATED_BODY()

public:
    virtual void Debug(const FString& Message, const TMap<FString, FString>& UserFields) override;
    virtual void Info(const FString& Message, const TMap<FString, FString>& UserFields) override;
    virtual void Warn(const FString& Message, const TMap<FString, FString>& UserFields) override;
    virtual void Error(const FString& Message, const TMap<FString, FString>& UserFields) override;
    virtual void Fatal(const FString& Message, const TMap<FString, FString>& UserFields) override;
    virtual void SetUserField(const FString& Key, const FString& Value) override;

private:
    friend class UGpLoggerCoreSubsystem;
    virtual void Initialize(const FString& Appkey, EGpLoggerServiceZone ServiceZone, UClass* LoggerClass);
    virtual void SetReserveField(const FString& Key, const FString& Value);

private:
    UPROPERTY()
    UGpBaseLogger* Logger;
};
