#include "GpLoggerSaveInfo.h"

namespace GpLoggerSaveInfo
{
    const FString StoreId { TEXT("NHN") };
    const FString Section { TEXT("GPLogger") };
}

void GpLoggerSaveInfo::SetStoreValue(
    const FString& Key,
    const FString& Value)
{
    FPlatformMisc::SetStoredValue(StoreId, Section, Key, Value);
}

TOptional<FString> GpLoggerSaveInfo::GetStoreValue(
    const FString& Key)
{
    FString GetValue;
    if (FPlatformMisc::GetStoredValue(StoreId, Section, Key, GetValue))
    {
        return GetValue;
    }

    return TOptional<FString>();
}
