﻿#include "GpLoggerLogInfo.h"

#include "GpLoggerInternalTypes.h"
#include "Utils/GpLoggerUtils.h"

using namespace GpLogger;

namespace GpLogger
{
    namespace AppInfo
    {
        const FString DefaultLogSource = TEXT("gp-sdk");
        const FString LogVersion = TEXT("v2");

    }
}

FGpLoggerLogData::FGpLoggerLogData(const FGpLoggerServiceData& ServiceData, const FString& Type, const EGpLogLevel Level, const FString& Message, const FString& TransactionId)
    : ServiceData(ServiceData)
{
    LogFields.Emplace(LogField::ProjectKey, ServiceData.Appkey);
    LogFields.Emplace(LogField::LogSource, AppInfo::DefaultLogSource);
    LogFields.Emplace(LogField::LogVersion, AppInfo::LogVersion);
    LogFields.Emplace(LogField::LogType, Type);
    LogFields.Emplace(LogField::LogLevel, GpLogger::EnumToString(Level).ToUpper());
    LogFields.Emplace(LogField::LogMessage, Message);
    LogFields.Emplace(LogField::LogTransactionID, TransactionId.IsEmpty() ? FGuid::NewGuid().ToString().ToLower() : TransactionId);
    LogFields.Emplace(LogField::LogCreateTime, FString::Printf(TEXT("%lld"), GetEpochTimeMs()));
}

void FGpLoggerLogData::SetUserField(const FString& Field, const FString& Value)
{
    LogFields.FindOrAdd(Field, Value);
}

void FGpLoggerLogData::SetUserFields(const TMap<FString, FString>& Fields)
{
    for (const auto& Field : Fields)
    {
        SetUserField(Field.Key, Field.Value);
    }
}

FString FGpLoggerLogData::GetAppkey() const
{
    return LogFields[LogField::ProjectKey];
}

EGpLogLevel FGpLoggerLogData::GetLogLevel() const
{
    return GpLogger::StringToEnum<EGpLogLevel>(LogFields[LogField::LogLevel]);
}

FString FGpLoggerLogData::GetLogType() const
{
    return LogFields[LogField::LogType];
}

FString FGpLoggerLogData::GetLogMessage() const
{
    return LogFields[LogField::LogMessage];
}

FString FGpLoggerLogData::GetLogSource() const
{
    return LogFields[LogField::LogSource];
}

FString FGpLoggerLogData::GetLogVersion() const
{
    return LogFields[LogField::LogVersion];
}

FString FGpLoggerLogData::GetUserId() const
{
    return LogFields[LogField::UserID];
}

int64 FGpLoggerLogData::GetCreateTime() const
{
    return FCString::Atoi64(*LogFields[LogField::LogCreateTime]);
}

FString FGpLoggerLogData::GetTransactionId() const
{
    return LogFields[LogField::LogTransactionID];
}

FString FGpLoggerLogData::Get(const FString& Field) const
{
    return LogFields.FindRef(Field);
}

FString FGpLoggerLogData::GetJsonString() const
{
    FString JsonString;
    for (const auto& Field: LogFields)
    {
        if (JsonString.IsEmpty() == false)
        {
            JsonString += TEXT(",");
        }
        
        JsonString += FString::Printf(TEXT("\"%s\":\"%s\""), *Field.Key, *Field.Value);
    }
    
    return FString::Printf(TEXT("{%s}"), *JsonString);
}

FString FGpLoggerLogData::GetDuplicateJsonString() const
{
    FString JsonString;
    for (const auto& Field: LogFields)
    {
        if (Field.Key.Equals(LogField::LogCreateTime) || Field.Key.Equals(LogField::LogTransactionID))
        {
            continue;
        }
        
        if (JsonString.IsEmpty() == false)
        {
            JsonString += TEXT(",");
        }
        
        JsonString += FString::Printf(TEXT("\"%s\":\"%s\""), *Field.Key, *Field.Value);
    }
    
    return FString::Printf(TEXT("{%s}"), *JsonString);
}

FGpLoggerServiceData FGpLoggerLogData::GetServiceData() const
{
    return ServiceData;
}

TArray<FString> FGpLoggerLogData::GetFields() const
{
    TArray<FString> Keys;
    LogFields.GetKeys(Keys);
    return Keys;
}

FString FGpLoggerBulkLogData::GetJsonString() const
{
    FString JsonString;
    for (const auto& Log : Logs)
    {
        if (JsonString.IsEmpty() == false)
        {
            JsonString += TEXT(",");
        }
        
        JsonString += Log.GetJsonString();
    }
    
    return FString::Printf(TEXT("[%s]"), *JsonString);
}
