﻿#include "GpLoggerInfo.h"

#include "GpLoggerDefines.h"
#include "Interfaces/IPluginManager.h"

namespace GpLoggerInfo
{
    const FName PluginName = TEXT("GPLogger");
}

FString GpLoggerInfo::GetPluginVersion()
{
    static FString PluginVersion;
    if (PluginVersion.IsEmpty())
    {
        const TSharedPtr<IPlugin> Plugin = IPluginManager::Get().FindPlugin(PluginName.ToString());
        if (Plugin.IsValid() == false)
        {
            GPLOGGER_LOG_WARNING("GPLogger plugin is not loaded");
        
            static const FString UnknownString = TEXT("UNKNOWN");
            PluginVersion = UnknownString;
        }
    
        PluginVersion = Plugin->GetDescriptor().VersionName;
    }
    
    return PluginVersion;
}

FString GpLoggerInfo::GetProjectVersion()
{
    static FString AppVersion;
    if (AppVersion.IsEmpty())
    {
        GConfig->GetString(
            TEXT("/Script/EngineSettings.GeneralProjectSettings"),
            TEXT("ProjectVersion"),
            AppVersion,
            GGameIni
        );
    }

    return AppVersion;
}