﻿#include "GpLoggerEngineSubsystem.h"

#include "Utils/GpLoggerSaveInfo.h"
#include "Crash/GpLoggerCrashManager.h"
#include "Internationalization/Culture.h"

void UGpLoggerEngineSubsystem::InitializeCrash(const FCrashInitializeParams& Params)
{
    CrashManager->Initialize(Params.bEnableReporter, Params.bEnableErrorLog);
}

FGpLoggerCrashDelegate& UGpLoggerEngineSubsystem::GetCrashDelegate() const
{
    return CrashManager->CrashDelegate;
}

void UGpLoggerEngineSubsystem::Initialize(FSubsystemCollectionBase& Collection)
{
    Super::Initialize(Collection);
    
    Platform = FString::Printf(TEXT("%s %s"), *FString(FPlatformProperties::PlatformName()), *FPlatformMisc::GetOSVersion());
    SessionId = FGuid::NewGuid().ToString().ToLower();
    LaunchedId = FGuid::NewGuid().ToString().ToLower();
    DeviceModel = FPlatformMisc::GetDeviceMakeAndModel();

    if (TOptional<FString> SavedDeviceId = GpLoggerSaveInfo::GetStoreValue(GpLoggerSaveKey::Udid))
    {
        DeviceId = *SavedDeviceId;
    }
    else
    {
        DeviceId = FGuid::NewGuid().ToString(EGuidFormats::DigitsWithHyphens).ToLower();
        GpLoggerSaveInfo::SetStoreValue(GpLoggerSaveKey::Udid, DeviceId);
    }
    
    CountryCode = FInternationalization::Get().GetDefaultCulture()->GetRegion();
    
    CrashManager = MakeShared<FGpLoggerCrashManager>();
}

void UGpLoggerEngineSubsystem::Deinitialize()
{
    Super::Deinitialize();
    
    CrashManager.Reset();
}