﻿#include "GpInternalInstanceLogger.h"

#include "GpBaseLogger.h"
#include "GpLoggerDefines.h"
#include "GpLoggerTypes.h"

void UGpInternalInstanceLogger::Debug(const FString& Message, const TMap<FString, FString>& UserFields)
{
    Logger->Log(EGpLogLevel::Debug, Message, UserFields);
}

void UGpInternalInstanceLogger::Info(const FString& Message, const TMap<FString, FString>& UserFields)
{
    Logger->Log(EGpLogLevel::Info, Message, UserFields);
}

void UGpInternalInstanceLogger::Warn(const FString& Message, const TMap<FString, FString>& UserFields)
{
    Logger->Log(EGpLogLevel::Warn, Message, UserFields);
}

void UGpInternalInstanceLogger::Error(const FString& Message, const TMap<FString, FString>& UserFields)
{
    Logger->Log(EGpLogLevel::Error, Message, UserFields);
}

void UGpInternalInstanceLogger::Fatal(const FString& Message, const TMap<FString, FString>& UserFields)
{
    Logger->Log(EGpLogLevel::Fatal, Message, UserFields);
}

void UGpInternalInstanceLogger::SetUserField(const FString& Key, const FString& Value)
{
    Logger->SetUserField(Key, Value);
}

void UGpInternalInstanceLogger::Initialize(const FString& Appkey, const EGpLoggerServiceZone ServiceZone, UClass* LoggerClass)
{
    if (Logger != nullptr)
    {
        GPLOGGER_LOG_DEBUG("Alradey initialize logger");
        return;
    }
    
    UGpBaseLogger::FInitializeParams Params;
    Params.Appkey = Appkey;
    Params.ServiceZone = ServiceZone;

    Logger = NewObject<UGpBaseLogger>(this, LoggerClass);
    Logger->Initialize(Params);
}

void UGpInternalInstanceLogger::SetReserveField(const FString& Key, const FString& Value)
{
    Logger->SetReserveField(Key, Value);
}
