﻿#pragma once

#include "CoreMinimal.h"
#include "GpLoggerInternalCrashTypes.h"

enum class EGpLogLevel : uint8;
struct FGpLoggerCrashInternalData;
class FGpLoggerOutputDevice;
class FGpLoggerOutputDeviceError;

class FGpLoggerCrashManager
{
public:
    FGpLoggerCrashManager();
    ~FGpLoggerCrashManager();

    void Initialize(bool bEnableCrashReporter, bool bEnableErrorReporter);
    
    FGpLoggerCrashDelegate CrashDelegate;

private:
    void OnCrashEvent(const FString& Message, EGpLogLevel Type, const FName& Name, TOptional<double> Time);
    
    void OnSystemError();
    void OnTerminate();
    
private:
    TUniquePtr<FGpLoggerOutputDevice> OutputDevice;
    TUniquePtr<FGpLoggerOutputDeviceError> OutputDeviceError;
};
 