#pragma once

namespace GpLoggerProtocol
{
    struct FHeader final : FGpLoggerJsonSerializable
    {
        FString TransactionId;
        
        BEGIN_GPLOGGER_JSON_SERIALIZER
            GPLOGGER_JSON_SERIALIZE("transactionId", TransactionId);
        END_GPLOGGER_JSON_SERIALIZER
    };
    
    struct FBaseResponse : FGpLoggerJsonSerializable
    {
        FString Uri;
        FHeader Header;
        
        BEGIN_GPLOGGER_JSON_SERIALIZER
            GPLOGGER_JSON_SERIALIZE("uri", Uri);
            GPLOGGER_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
        END_GPLOGGER_JSON_SERIALIZER
    };

    struct FBaseBody : FGpLoggerJsonSerializable
    {
        bool bIsSuccessful;
        int ResultCode;
        FString ResultMessage;
        
        BEGIN_GPLOGGER_JSON_SERIALIZER
            GPLOGGER_JSON_SERIALIZE("bIsSuccessful", bIsSuccessful);
            GPLOGGER_JSON_SERIALIZE("resultCode", ResultCode);
            GPLOGGER_JSON_SERIALIZE("resultMessage", ResultMessage);
        END_GPLOGGER_JSON_SERIALIZER
    };

    struct FLog final : FGpLoggerJsonSerializable
    {
        FString Type;
        FString Level;
        FString Message;
        int64 CreateTime;
        FString TransactionId;
        TMap<FString, FString> UserFields;
        
        BEGIN_GPLOGGER_JSON_SERIALIZER
            GPLOGGER_JSON_SERIALIZE("type", Type);
            GPLOGGER_JSON_SERIALIZE("level", Level);
            GPLOGGER_JSON_SERIALIZE("message", Message);
            GPLOGGER_JSON_SERIALIZE("createTime", CreateTime);
            GPLOGGER_JSON_SERIALIZE("transactionId", TransactionId);
            GPLOGGER_JSON_SERIALIZE_MAP("userFields", UserFields);
        END_GPLOGGER_JSON_SERIALIZER
    };

    struct FExceptionResponse final : FBaseResponse
    {
        FBaseBody Body;
        
        BEGIN_GPLOGGER_JSON_SERIALIZER
            GPLOGGER_JSON_SERIALIZE("uri", Uri);
            GPLOGGER_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
            GPLOGGER_JSON_SERIALIZE_OBJECT_SERIALIZABLE("body", Body);
        END_GPLOGGER_JSON_SERIALIZER
    };

    namespace SetLoggerListener
    {
        struct FSuccessResponse final : FBaseResponse
        {
            struct FBody final : FBaseBody
            {
                FLog Log;
                
                BEGIN_GPLOGGER_JSON_SERIALIZER
                    GPLOGGER_JSON_SERIALIZE("bIsSuccessful", bIsSuccessful);
                    GPLOGGER_JSON_SERIALIZE("resultCode", ResultCode);
                    GPLOGGER_JSON_SERIALIZE("resultMessage", ResultMessage);
                    GPLOGGER_JSON_SERIALIZE_OBJECT_SERIALIZABLE("log", Log);
                END_GPLOGGER_JSON_SERIALIZER
            };
            
            FBody Body;
            
            BEGIN_GPLOGGER_JSON_SERIALIZER
                GPLOGGER_JSON_SERIALIZE("uri", Uri);
                GPLOGGER_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
                GPLOGGER_JSON_SERIALIZE_OBJECT_SERIALIZABLE("body", Body);
            END_GPLOGGER_JSON_SERIALIZER
        };

        struct FFilterResponse final : FBaseResponse
        {
            struct FBody final : FBaseBody
            {
                struct FFilter final : FGpLoggerJsonSerializable
                {
                    FString Name;
                    
                    BEGIN_GPLOGGER_JSON_SERIALIZER
                        GPLOGGER_JSON_SERIALIZE("name", Name);
                    END_GPLOGGER_JSON_SERIALIZER
                };
                
                FLog Log;
                FFilter Filter;
                
                BEGIN_GPLOGGER_JSON_SERIALIZER
                    GPLOGGER_JSON_SERIALIZE("bIsSuccessful", bIsSuccessful);
                    GPLOGGER_JSON_SERIALIZE("resultCode", ResultCode);
                    GPLOGGER_JSON_SERIALIZE("resultMessage", ResultMessage);
                    GPLOGGER_JSON_SERIALIZE_OBJECT_SERIALIZABLE("log", Log);
                    GPLOGGER_JSON_SERIALIZE_OBJECT_SERIALIZABLE("filter", Filter);
                END_GPLOGGER_JSON_SERIALIZER
            };
            
            FBody Body;
            
            BEGIN_GPLOGGER_JSON_SERIALIZER
                GPLOGGER_JSON_SERIALIZE("uri", Uri);
                GPLOGGER_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
                GPLOGGER_JSON_SERIALIZE_OBJECT_SERIALIZABLE("body", Body);
            END_GPLOGGER_JSON_SERIALIZER
        };
        
        struct FSaveResponse final : FBaseResponse
        {
            struct FBody final : FBaseBody
            {
                FLog Log;
                
                BEGIN_GPLOGGER_JSON_SERIALIZER
                    GPLOGGER_JSON_SERIALIZE("bIsSuccessful", bIsSuccessful);
                    GPLOGGER_JSON_SERIALIZE("resultCode", ResultCode);
                    GPLOGGER_JSON_SERIALIZE("resultMessage", ResultMessage);
                    GPLOGGER_JSON_SERIALIZE_OBJECT_SERIALIZABLE("log", Log);
                END_GPLOGGER_JSON_SERIALIZER
            };
            
            FBody Body;
            
            BEGIN_GPLOGGER_JSON_SERIALIZER
                GPLOGGER_JSON_SERIALIZE("uri", Uri);
                GPLOGGER_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
                GPLOGGER_JSON_SERIALIZE_OBJECT_SERIALIZABLE("body", Body);
            END_GPLOGGER_JSON_SERIALIZER
        };
        
        struct FErrorResponse final : FBaseResponse
        {
            struct FBody final : FBaseBody
            {
                FLog Log;
                FString ErrorMessage;
                
                BEGIN_GPLOGGER_JSON_SERIALIZER
                    GPLOGGER_JSON_SERIALIZE("bIsSuccessful", bIsSuccessful);
                    GPLOGGER_JSON_SERIALIZE("resultCode", ResultCode);
                    GPLOGGER_JSON_SERIALIZE("resultMessage", ResultMessage);
                    GPLOGGER_JSON_SERIALIZE_OBJECT_SERIALIZABLE("log", Log);
                    GPLOGGER_JSON_SERIALIZE("errorMessage", ErrorMessage);
                END_GPLOGGER_JSON_SERIALIZER
            };
            
            FBody Body;
            
            BEGIN_GPLOGGER_JSON_SERIALIZER
                GPLOGGER_JSON_SERIALIZE("uri", Uri);
                GPLOGGER_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
                GPLOGGER_JSON_SERIALIZE_OBJECT_SERIALIZABLE("body", Body);
            END_GPLOGGER_JSON_SERIALIZER
        };
    }
}