#pragma once

#include "GpLoggerProtocolBase.h"

namespace GpLoggerProtocol
{   
    namespace Payload
    {
        struct FInitializeInstancePayload final : FBasePayload
        {
            FString ProjectKey;
            FString ServiceZone;
            FString Setting;
            
            BEGIN_GPLOGGER_JSON_SERIALIZER
                GPLOGGER_JSON_SERIALIZE("projectKey", ProjectKey);
                GPLOGGER_JSON_SERIALIZE("serviceZone", ServiceZone);
                GPLOGGER_JSON_SERIALIZE("setting", Setting);
            END_GPLOGGER_JSON_SERIALIZER
        };

        struct FLogInstancePayload final : FBasePayload
        {
            FString Type;
            FString Level;
            FString Message;
            TMap<FString, FString> UserFields;
            
            BEGIN_GPLOGGER_JSON_SERIALIZER
                GPLOGGER_JSON_SERIALIZE("type", Type);
                GPLOGGER_JSON_SERIALIZE("level", Level);
                GPLOGGER_JSON_SERIALIZE("message", Message);
                GPLOGGER_JSON_SERIALIZE_MAP("userFields", UserFields);
            END_GPLOGGER_JSON_SERIALIZER
        };
        
        struct FSetUserFieldPayload final : FBasePayload
        {
            FString Key;
            FString Value;
                
            BEGIN_GPLOGGER_JSON_SERIALIZER
                GPLOGGER_JSON_SERIALIZE("key", Key);
                GPLOGGER_JSON_SERIALIZE("value", Value);
            END_GPLOGGER_JSON_SERIALIZER
        };
    }
        
    struct FInitializeInstanceRequest final : TBridgeProtocol<Payload::FInitializeInstancePayload>
    {
        explicit FInitializeInstanceRequest(const Payload::FInitializeInstancePayload& Payload)
            : TBridgeProtocol(TEXT("toast://logger/") + Payload.ProjectKey + TEXT("/initialize"), Payload)
        {
        }
    };
        
    struct FLogInstanceRequest final : TBridgeProtocol<Payload::FLogInstancePayload>
    {
        FLogInstanceRequest(const FString& Appkey, const Payload::FLogInstancePayload& Payload)
            : TBridgeProtocol(TEXT("toast://logger/") + Appkey + TEXT("/log"), Payload)
        {
        }
    };
        
    struct FSetUserFieldInstanceRequest final : TBridgeProtocol<Payload::FSetUserFieldPayload>
    {
        FSetUserFieldInstanceRequest(const FString& Appkey, const Payload::FSetUserFieldPayload& Payload)
            : TBridgeProtocol(TEXT("toast://logger/") + Appkey + TEXT("/setuserfield"), Payload)
        {
        }
    };
}