#pragma once

#include "GpLoggerProtocolBase.h"

namespace GpLoggerProtocol
{   
    namespace Payload
    {
        struct FSetDebugModePayload final : FBasePayload
        {
            bool DebugMode;
            
            BEGIN_GPLOGGER_JSON_SERIALIZER
                GPLOGGER_JSON_SERIALIZE("debugMode", DebugMode);
            END_GPLOGGER_JSON_SERIALIZER
        };
    }
    
    struct FSetDebugModeRequest final : TBridgeProtocol<Payload::FSetDebugModePayload>
    {
        explicit FSetDebugModeRequest(const bool bDebugMode)
            : TBridgeProtocol(TEXT("toast://logger/setdebugmode"))
        {
            Payload.DebugMode = bDebugMode;
        }
    };

    struct FGetDebugModeRequest final : TBridgeProtocol<>
    {
        explicit FGetDebugModeRequest()
            : TBridgeProtocol(TEXT("toast://logger/isdebugmode"))
        {
        }
    };

    struct FGetDebugModeResponse final : FGpLoggerJsonSerializable
    {
        bool bDebugMode;
        
        BEGIN_GPLOGGER_JSON_SERIALIZER
            GPLOGGER_JSON_SERIALIZE("debugMode", bDebugMode);
        END_GPLOGGER_JSON_SERIALIZER
    };
}