﻿#include "GpLoggerIOSBridge.h"

#include "GpBridgeLogger.h"

extern "C" {
    char* GPLoggerPlugin_receiveMessageFromEngine(const char* message);

    void UnrealSendMessage(const char* methodName, const char* jsonString)
    {
        if (UGpBridgeLogger* Logger = UGpBridgeLogger::Get())
        {
            Logger->ReceiveMessage(FString(methodName), FString(jsonString));
        }
    }
}


FGpLoggerIOSBridge::FGpLoggerIOSBridge()
{
}

FGpLoggerIOSBridge::~FGpLoggerIOSBridge()
{
}

FString FGpLoggerIOSBridge::SendMessage(const FString& JsonString)
{
    return FString(UTF8_TO_TCHAR(GPLoggerPlugin_receiveMessageFromEngine(TCHAR_TO_UTF8(*JsonString))));
}