#pragma once

#include "CoreMinimal.h"

class IGpLoggerNativeBridge
{
public:
    virtual ~IGpLoggerNativeBridge() = default;
    
    virtual FString SendMessage(const FString& JsonString) = 0;
    
    void SetDebugMode(bool bIsDebugMode);
    bool GetDebugMode();
};

class FGpLoggerDummyBridge final : public IGpLoggerNativeBridge
{
public:
    FGpLoggerDummyBridge() {}
    virtual ~FGpLoggerDummyBridge() override = default;
    
    virtual FString SendMessage(const FString& JsonString) override { checkNoEntry(); return {}; }
};